/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.health;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DataSourceHealthIndicator
extends AbstractHealthIndicator
implements InitializingBean {
    private @Nullable DataSource dataSource;
    private @Nullable String query;
    private @Nullable JdbcTemplate jdbcTemplate;

    public DataSourceHealthIndicator() {
        this(null, null);
    }

    public DataSourceHealthIndicator(@Nullable DataSource dataSource) {
        this(dataSource, null);
    }

    public DataSourceHealthIndicator(@Nullable DataSource dataSource, @Nullable String query) {
        super("DataSource health check failed");
        this.dataSource = dataSource;
        this.query = query;
        this.jdbcTemplate = dataSource != null ? new JdbcTemplate(dataSource) : null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource for DataSourceHealthIndicator must be specified");
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.dataSource == null) {
            builder.up().withDetail("database", (Object)"unknown");
        } else {
            this.doDataSourceHealthCheck(builder);
        }
    }

    private void doDataSourceHealthCheck(Health.Builder builder) {
        Assert.state((this.jdbcTemplate != null ? 1 : 0) != 0, (String)"'jdbcTemplate' must not be null");
        builder.up().withDetail("database", (Object)this.getProduct(this.jdbcTemplate));
        String validationQuery = this.query;
        if (StringUtils.hasText((String)validationQuery)) {
            builder.withDetail("validationQuery", (Object)validationQuery);
            List results = this.jdbcTemplate.query(validationQuery, (RowMapper)new SingleColumnRowMapper());
            Object result = DataAccessUtils.requiredSingleResult((Collection)results);
            builder.withDetail("result", result);
        } else {
            builder.withDetail("validationQuery", (Object)"isValid()");
            boolean valid = this.isConnectionValid(this.jdbcTemplate);
            builder.status(valid ? Status.UP : Status.DOWN);
        }
    }

    private String getProduct(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(this::getProduct);
    }

    private String getProduct(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseProductName();
    }

    private Boolean isConnectionValid(JdbcTemplate jdbcTemplate) {
        return (Boolean)jdbcTemplate.execute(this::isConnectionValid);
    }

    private Boolean isConnectionValid(Connection connection) throws SQLException {
        return connection.isValid(0);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public @Nullable String getQuery() {
        return this.query;
    }

    private static final class SingleColumnRowMapper
    implements RowMapper<Object> {
        private SingleColumnRowMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            ResultSetMetaData metaData = rs.getMetaData();
            int columns = metaData.getColumnCount();
            if (columns != 1) {
                throw new IncorrectResultSetColumnCountException(1, columns);
            }
            Object result = JdbcUtils.getResultSetValue((ResultSet)rs, (int)1);
            Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
            return result;
        }
    }
}

