/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.maven.ClassPath;

final class CommandLineBuilder {
    private final List<String> options = new ArrayList<String>();
    private final List<URL> classpathElements = new ArrayList<URL>();
    private final String mainClass;
    private final List<String> arguments = new ArrayList<String>();

    private CommandLineBuilder(String mainClass) {
        this.mainClass = mainClass;
    }

    static CommandLineBuilder forMainClass(String mainClass) {
        return new CommandLineBuilder(mainClass);
    }

    CommandLineBuilder withJvmArguments(String ... jvmArguments) {
        if (jvmArguments != null) {
            this.options.addAll(Arrays.stream(jvmArguments).filter(Objects::nonNull).toList());
        }
        return this;
    }

    CommandLineBuilder withSystemProperties(@Nullable Map<String, String> systemProperties) {
        if (systemProperties != null) {
            systemProperties.entrySet().stream().map(e -> SystemPropertyFormatter.format((String)e.getKey(), (String)e.getValue())).forEach(this.options::add);
        }
        return this;
    }

    CommandLineBuilder withClasspath(URL ... elements) {
        this.classpathElements.addAll(Arrays.asList(elements));
        return this;
    }

    CommandLineBuilder withArguments(String ... arguments) {
        if (arguments != null) {
            this.arguments.addAll(Arrays.stream(arguments).filter(Objects::nonNull).toList());
        }
        return this;
    }

    List<String> build() {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (!this.options.isEmpty()) {
            commandLine.addAll(this.options);
        }
        commandLine.addAll(ClassPath.of(this.classpathElements).args(true));
        commandLine.add(this.mainClass);
        if (!this.arguments.isEmpty()) {
            commandLine.addAll(this.arguments);
        }
        return commandLine;
    }

    private static final class SystemPropertyFormatter {
        private SystemPropertyFormatter() {
        }

        static String format(@Nullable String key, @Nullable String value) {
            if (key == null) {
                return "";
            }
            if (value == null || value.isEmpty()) {
                return String.format("-D%s", key);
            }
            return String.format("-D%s=\"%s\"", key, value);
        }
    }
}

