/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.AbstractDefaultIndexOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultTransportIndexOperations
extends AbstractDefaultIndexOperations
implements IndexOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransportIndexOperations.class);
    private final Client client;

    public DefaultTransportIndexOperations(Client client, ElasticsearchConverter elasticsearchConverter, Class<?> boundClass) {
        super(elasticsearchConverter, boundClass);
        this.client = client;
    }

    public DefaultTransportIndexOperations(Client client, ElasticsearchConverter elasticsearchConverter, IndexCoordinates boundIndex) {
        super(elasticsearchConverter, boundIndex);
        this.client = client;
    }

    @Override
    protected boolean doCreate(IndexCoordinates index, @Nullable Document settings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.requestFactory.createIndexRequestBuilder(this.client, index, settings);
        return ((CreateIndexResponse)createIndexRequestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    protected boolean doDelete(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for delete operation");
        if (this.doExists(index)) {
            DeleteIndexRequest deleteIndexRequest = this.requestFactory.deleteIndexRequest(index);
            return ((AcknowledgedResponse)this.client.admin().indices().delete(deleteIndexRequest).actionGet()).isAcknowledged();
        }
        return false;
    }

    @Override
    protected boolean doExists(IndexCoordinates index) {
        IndicesExistsRequest indicesExistsRequest = this.requestFactory.indicesExistsRequest(index);
        return ((IndicesExistsResponse)this.client.admin().indices().exists(indicesExistsRequest).actionGet()).isExists();
    }

    @Override
    protected boolean doPutMapping(IndexCoordinates index, Document mapping) {
        Assert.notNull((Object)index, (String)"No index defined for putMapping()");
        PutMappingRequestBuilder requestBuilder = this.requestFactory.putMappingRequestBuilder(this.client, index, mapping);
        return ((AcknowledgedResponse)requestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    protected Map<String, Object> doGetMapping(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for getMapping()");
        GetMappingsRequest mappingsRequest = this.requestFactory.getMappingsRequest(this.client, index);
        ImmutableOpenMap mappings = ((GetMappingsResponse)this.client.admin().indices().getMappings(mappingsRequest).actionGet()).getMappings();
        if (mappings == null || mappings.size() == 0) {
            return Collections.emptyMap();
        }
        if (mappings.size() > 1) {
            LOGGER.warn("more than one mapping returned for " + index.getIndexName());
        }
        return ((MappingMetadata)((ImmutableOpenMap)((ObjectObjectCursor)mappings.iterator().next()).value).get((Object)"_doc")).getSourceAsMap();
    }

    @Override
    protected boolean doAddAlias(AliasQuery query, IndexCoordinates index) {
        IndicesAliasesRequest.AliasActions aliasAction = this.requestFactory.aliasAction(query, index);
        return ((AcknowledgedResponse)this.client.admin().indices().prepareAliases().addAliasAction(aliasAction).execute().actionGet()).isAcknowledged();
    }

    @Override
    protected boolean doRemoveAlias(AliasQuery query, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        IndicesAliasesRequestBuilder indicesAliasesRequestBuilder = this.requestFactory.indicesRemoveAliasesRequestBuilder(this.client, query, index);
        return ((AcknowledgedResponse)indicesAliasesRequestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    protected List<AliasMetadata> doQueryForAlias(IndexCoordinates index) {
        GetAliasesRequest getAliasesRequest = this.requestFactory.getAliasesRequest(index);
        return (List)((GetAliasesResponse)this.client.admin().indices().getAliases(getAliasesRequest).actionGet()).getAliases().get((Object)index.getIndexName());
    }

    @Override
    protected Map<String, Set<AliasData>> doGetAliases(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasesRequest getAliasesRequest = this.requestFactory.getAliasesRequest(aliasNames, indexNames);
        ImmutableOpenMap aliases = ((GetAliasesResponse)this.client.admin().indices().getAliases(getAliasesRequest).actionGet()).getAliases();
        LinkedHashMap<String, Set<AliasMetadata>> aliasesResponse = new LinkedHashMap<String, Set<AliasMetadata>>();
        aliases.keysIt().forEachRemaining(index -> {
            Set cfr_ignored_0 = aliasesResponse.put((String)index, new HashSet((Collection)aliases.get(index)));
        });
        return this.requestFactory.convertAliasesResponse(aliasesResponse);
    }

    @Override
    public boolean alias(AliasActions aliasActions) {
        IndicesAliasesRequestBuilder indicesAliasesRequestBuilder = this.requestFactory.indicesAliasesRequestBuilder(this.client, aliasActions);
        return ((AcknowledgedResponse)indicesAliasesRequestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    protected Map<String, Object> doGetSettings(IndexCoordinates index, boolean includeDefaults) {
        Assert.notNull((Object)index, (String)"index must not be null");
        GetSettingsRequest getSettingsRequest = this.requestFactory.getSettingsRequest(index, includeDefaults);
        GetSettingsResponse response = (GetSettingsResponse)this.client.admin().indices().getSettings(getSettingsRequest).actionGet();
        return this.requestFactory.fromSettingsResponse(response, index.getIndexName());
    }

    @Override
    protected void doRefresh(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        RefreshRequest request = this.requestFactory.refreshRequest(index);
        this.client.admin().indices().refresh(request).actionGet();
    }

    @Override
    public boolean putTemplate(PutTemplateRequest putTemplateRequest) {
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        PutIndexTemplateRequest putIndexTemplateRequest = this.requestFactory.putIndexTemplateRequest(this.client, putTemplateRequest);
        return ((AcknowledgedResponse)this.client.admin().indices().putTemplate(putIndexTemplateRequest).actionGet()).isAcknowledged();
    }

    @Override
    public TemplateData getTemplate(GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        GetIndexTemplatesRequest getIndexTemplatesRequest = this.requestFactory.getIndexTemplatesRequest(this.client, getTemplateRequest);
        GetIndexTemplatesResponse getIndexTemplatesResponse = (GetIndexTemplatesResponse)this.client.admin().indices().getTemplates(getIndexTemplatesRequest).actionGet();
        for (IndexTemplateMetadata indexTemplateMetadata : getIndexTemplatesResponse.getIndexTemplates()) {
            if (!indexTemplateMetadata.getName().equals(getTemplateRequest.getTemplateName())) continue;
            Document settings = Document.create();
            Settings templateSettings = indexTemplateMetadata.settings();
            templateSettings.keySet().forEach(key -> settings.put(key, templateSettings.get(key)));
            LinkedHashMap<String, AliasData> aliases = new LinkedHashMap<String, AliasData>();
            ImmutableOpenMap aliasesResponse = indexTemplateMetadata.aliases();
            Iterator keysItAliases = aliasesResponse.keysIt();
            while (keysItAliases.hasNext()) {
                String key2 = (String)keysItAliases.next();
                aliases.put(key2, this.requestFactory.convertAliasMetadata((AliasMetadata)aliasesResponse.get((Object)key2)));
            }
            LinkedHashMap<String, String> mappingsDoc = new LinkedHashMap<String, String>();
            ImmutableOpenMap mappingsResponse = indexTemplateMetadata.mappings();
            Iterator keysItMappings = mappingsResponse.keysIt();
            while (keysItMappings.hasNext()) {
                String key3 = (String)keysItMappings.next();
                mappingsDoc.put(key3, ((CompressedXContent)mappingsResponse.get((Object)key3)).string());
            }
            String mappingsJson = (String)mappingsDoc.get("_doc");
            Document mapping = null;
            if (mappingsJson != null) {
                try {
                    mapping = Document.from((Map)Document.parse(mappingsJson).get("_doc"));
                }
                catch (Exception e) {
                    LOGGER.warn("Got invalid mappings JSON: {}", (Object)mappingsJson);
                }
            }
            TemplateData templateData = TemplateData.builder().withIndexPatterns(indexTemplateMetadata.patterns().toArray(new String[0])).withSettings(settings).withMapping(mapping).withAliases(aliases).withOrder(indexTemplateMetadata.order()).withVersion(indexTemplateMetadata.version()).build();
            return templateData;
        }
        return null;
    }

    @Override
    public boolean existsTemplate(ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        return this.getTemplate(new GetTemplateRequest(existsTemplateRequest.getTemplateName())) != null;
    }

    @Override
    public boolean deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        Assert.notNull((Object)deleteTemplateRequest, (String)"deleteTemplateRequest must not be null");
        DeleteIndexTemplateRequest deleteIndexTemplateRequest = this.requestFactory.deleteIndexTemplateRequest(this.client, deleteTemplateRequest);
        return ((AcknowledgedResponse)this.client.admin().indices().deleteTemplate(deleteIndexTemplateRequest).actionGet()).isAcknowledged();
    }
}

