/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchHitsImpl<T>
implements SearchScrollHits<T> {
    private final long totalHits;
    private final TotalHitsRelation totalHitsRelation;
    private final float maxScore;
    @Nullable
    private final String scrollId;
    private final List<? extends SearchHit<T>> searchHits;
    private final Lazy<List<SearchHit<T>>> unmodifiableSearchHits;
    @Nullable
    private final Aggregations aggregations;

    public SearchHitsImpl(long totalHits, TotalHitsRelation totalHitsRelation, float maxScore, @Nullable String scrollId, List<? extends SearchHit<T>> searchHits, @Nullable Aggregations aggregations) {
        Assert.notNull(searchHits, (String)"searchHits must not be null");
        this.totalHits = totalHits;
        this.totalHitsRelation = totalHitsRelation;
        this.maxScore = maxScore;
        this.scrollId = scrollId;
        this.searchHits = searchHits;
        this.aggregations = aggregations;
        this.unmodifiableSearchHits = Lazy.of(() -> Collections.unmodifiableList(searchHits));
    }

    @Override
    public long getTotalHits() {
        return this.totalHits;
    }

    @Override
    public TotalHitsRelation getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    @Override
    public float getMaxScore() {
        return this.maxScore;
    }

    @Override
    @Nullable
    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public List<SearchHit<T>> getSearchHits() {
        return (List)this.unmodifiableSearchHits.get();
    }

    @Override
    public SearchHit<T> getSearchHit(int index) {
        return this.searchHits.get(index);
    }

    public String toString() {
        return "SearchHits{totalHits=" + this.totalHits + ", totalHitsRelation=" + (Object)((Object)this.totalHitsRelation) + ", maxScore=" + this.maxScore + ", scrollId='" + this.scrollId + '\'' + ", searchHits={" + this.searchHits.size() + " elements}, aggregations=" + this.aggregations + '}';
    }

    @Override
    @Nullable
    public Aggregations getAggregations() {
        return this.aggregations;
    }
}

