/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.UserSelection;
import org.springframework.data.neo4j.core.support.UserAgent;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.util.ReflectionUtils;

public final class Neo4jTransactionUtils {
    private static final Method WITH_IMPERSONATED_USER = ReflectionUtils.findMethod(SessionConfig.Builder.class, (String)"withImpersonatedUser", (Class[])new Class[]{String.class});

    public static boolean driverSupportsImpersonation() {
        return WITH_IMPERSONATED_USER != null;
    }

    public static SessionConfig.Builder withImpersonatedUser(SessionConfig.Builder builder, String user) {
        if (Neo4jTransactionUtils.driverSupportsImpersonation()) {
            return (SessionConfig.Builder)ReflectionUtils.invokeMethod((Method)WITH_IMPERSONATED_USER, (Object)builder, (Object[])new Object[]{user});
        }
        return builder;
    }

    public static SessionConfig defaultSessionConfig(DatabaseSelection databaseSelection, UserSelection asUser) {
        return Neo4jTransactionUtils.sessionConfig(false, Collections.emptyList(), databaseSelection, asUser);
    }

    public static SessionConfig sessionConfig(boolean readOnly, Collection<Bookmark> bookmarks, DatabaseSelection databaseSelection, UserSelection asUser) {
        SessionConfig.Builder builder = SessionConfig.builder().withDefaultAccessMode(readOnly ? AccessMode.READ : AccessMode.WRITE).withBookmarks(bookmarks);
        if (databaseSelection.getValue() != null) {
            builder.withDatabase(databaseSelection.getValue());
        }
        if (Neo4jTransactionUtils.driverSupportsImpersonation() && asUser.getValue() != null) {
            Neo4jTransactionUtils.withImpersonatedUser(builder, asUser.getValue());
        }
        return builder.build();
    }

    static TransactionConfig createTransactionConfigFrom(TransactionDefinition definition, int defaultTxManagerTimeout) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Neo4jTransactionManager is not allowed to support custom isolation levels.");
        }
        int propagationBehavior = definition.getPropagationBehavior();
        if (propagationBehavior != 0 && propagationBehavior != 3) {
            throw new IllegalTransactionStateException("Neo4jTransactionManager only supports 'required' or 'requires new' propagation.");
        }
        TransactionConfig.Builder builder = TransactionConfig.builder();
        if (definition.getTimeout() > 0) {
            builder = builder.withTimeout(Duration.ofSeconds(definition.getTimeout()));
        } else if (defaultTxManagerTimeout > 0) {
            builder = builder.withTimeout(Duration.ofSeconds(defaultTxManagerTimeout));
        }
        return builder.withMetadata(Collections.singletonMap("app", UserAgent.INSTANCE.toString())).build();
    }

    static String formatOngoingTxInAnotherDbErrorMessage(DatabaseSelection currentDb, DatabaseSelection requestedDb, UserSelection currentUser, UserSelection requestedUser) {
        String defaultDatabase = "the default database";
        String defaultUser = "the default user";
        String _currentDb = currentDb.getValue() == null ? defaultDatabase : String.format("'%s'", currentDb.getValue());
        String _requestedDb = requestedDb.getValue() == null ? defaultDatabase : String.format("'%s'", requestedDb.getValue());
        String _currentUser = currentUser.getValue() == null ? defaultUser : String.format("'%s'", currentUser.getValue());
        String _requestedUser = requestedUser.getValue() == null ? defaultUser : String.format("'%s'", requestedUser.getValue());
        return String.format("There is already an ongoing Spring transaction for %s of %s, but you requested %s of %s", _currentUser, _currentDb, _requestedUser, _requestedDb);
    }

    private Neo4jTransactionUtils() {
    }
}

