/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.reactive.function.client;

import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public final class ServletBearerExchangeFilterFunction
implements ExchangeFilterFunction {
    static final String SECURITY_REACTOR_CONTEXT_ATTRIBUTES_KEY = "org.springframework.security.SECURITY_CONTEXT_ATTRIBUTES";

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.oauth2Token().map(token -> this.bearer(request, (OAuth2Token)token)).defaultIfEmpty((Object)request).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0));
    }

    private Mono<OAuth2Token> oauth2Token() {
        return Mono.deferContextual(Mono::just).cast(Context.class).flatMap(this::currentAuthentication).filter(authentication -> authentication.getCredentials() instanceof OAuth2Token).map(Authentication::getCredentials).cast(OAuth2Token.class);
    }

    private Mono<Authentication> currentAuthentication(Context ctx) {
        return Mono.justOrEmpty((Object)this.getAttribute(ctx, Authentication.class));
    }

    private <T> T getAttribute(Context ctx, Class<T> clazz) {
        if (!ctx.hasKey((Object)SECURITY_REACTOR_CONTEXT_ATTRIBUTES_KEY)) {
            return null;
        }
        Map attributes = (Map)ctx.get((Object)SECURITY_REACTOR_CONTEXT_ATTRIBUTES_KEY);
        return (T)attributes.get(clazz);
    }

    private ClientRequest bearer(ClientRequest request, OAuth2Token token) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(token.getTokenValue())).build();
    }
}

