/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.alibaba.fastjson.JSON;
import com.github.javaparser.utils.Log;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.layer.Label;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.utfgrid.IUtfgridInfo;
import com.northpool.service.config.vector_service.utfgrid.UtfgridInfoBean;
import com.northpool.service.config.vector_service.utfgrid.UtfgridInfoShell;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.QuadtreeGrid;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.northpool.tiledispatch.task.task.TileServerCutTask;
import com.northpool.tiledispatch.task.task.UtfgridTileCutTask;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.sfg.debugger.buzidata.BuziUtil;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.config.CutConfig;
import com.sfg.debugger.cuttask.TaskLauncher;
import com.sfg.debugger.filter.LayerFilter;
import com.sfg.debugger.filter.LevelFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutSchemaV2 {
    private static Logger LOG = LoggerFactory.getLogger(CutSchemaV2.class);
    static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
    static Client client;
    static IVectorService service;
    static MongodbDataSource tileMogoDS;
    static String mapName;
    static int l1;
    static int l2;
    static Map<String, Map<String, String>> levelDataFilters;

    public static void main(String[] args) {
        try {
            CutSchemaV2.setUp();
            CutSchemaV2.cutMapWithUTFGrid();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    static void testEx01() throws Exception {
        try {
            int ret = 12 / 0;
            System.out.println("testEx,successfully");
        }
        catch (Exception e) {
            System.out.println("testEx, catch exception");
            throw e;
        }
        finally {
            System.out.println("testEx, finally");
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        GlobalTileSettings.bAccurateCut = false;
        GlobalTileSettings.bAccurateIntersect = false;
        GlobalTileSettings.UTFGRID_SYNC_TIMEOUT_MILLIS = 1000;
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        GlobalTileSettings.RTT_THREAD_COUNT = 1;
        int poolSize = 100;
        DBPoolParameter.DEFAULT.setMinIdle(1);
        DBPoolParameter.DEFAULT.setInitialSize(1);
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl);
        IVectorServiceManager svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(mapName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + mapName);
        }
        tileMogoDS = (MongodbDataSource)((IDataSourceInService)client.getDataSourcesManager().get(conf.mogoTileDbId)).getBean();
        System.out.println("=== config completed ===");
    }

    private static void cutMap() throws Exception {
        l1 = 7;
        l2 = 10;
        AbstractTileDispatchTask task = CutSchemaV2.buildTaskV2();
        CountDownLatch latch = new CountDownLatch(1);
        TaskLauncher.launchTask(task, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== \u5207\u7247\u6d4b\u8bd5\u7ed3\u675f ==========");
        System.exit(0);
    }

    private static AbstractTileDispatchTask buildTaskV2() {
        TileServerCutTask task = new TileServerCutTask(service.getId(), service, (IGridSystem)grid, tileMogoDS, Integer.valueOf(l1), Integer.valueOf(l2));
        return task;
    }

    private static void addCutFilters() throws Exception {
        String svcId = service.getId();
        String json = BuziUtil.getCutFiltersFromPG(svcId);
        if (StringUtils.isEmpty((CharSequence)json)) {
            throw new Exception("\u672a\u627e\u5230\u670d\u52a1" + svcId + "\u7684\u5207\u7247\u65b9\u6848");
        }
        CutConfig cutcfg = (CutConfig)JSON.parseObject((String)json, CutConfig.class);
        String cacheDatasourceId = cutcfg.getCacheDatasourceId();
        int beginLevel = cutcfg.getCutLevel()[0];
        int endLevel = cutcfg.getCutLevel()[1];
        List<LevelFilter> filters = cutcfg.getStyleFilters();
        if (filters == null || filters.isEmpty()) {
            return;
        }
        String LEVEL_SEPARATOR = "-";
        HashMap<String, String> filterMap = new HashMap<String, String>();
        for (LevelFilter filter : filters) {
            String strLevel = filter.getLevel();
            for (LayerFilter layer : filter.getLayers()) {
                String filterStr = layer.getFilter();
                if (StringUtils.isNotEmpty((CharSequence)filterStr)) {
                    filterStr = filterStr.replace("\"", "'");
                }
                String layerName = layer.getLayer();
                if (strLevel.contains("-")) {
                    String[] levels = strLevel.split("-");
                    int from = Integer.valueOf(levels[0]);
                    int to = Integer.valueOf(levels[1]);
                    for (int i = from; i <= to; ++i) {
                        filterMap.put(i + "-" + layerName, filterStr);
                        CutSchemaV2.addFilterToMap(i + "", layerName, filterStr);
                    }
                    continue;
                }
                filterMap.put(strLevel + "-" + layerName, filterStr);
                CutSchemaV2.addFilterToMap(strLevel, layerName, filterStr);
            }
        }
        String jsonFilters = JSON.toJSONString(levelDataFilters, (boolean)true);
        LOG.info("\u5207\u7247\u8fc7\u6ee4\u6761\u4ef6\u8868\uff1a {}", (Object)jsonFilters);
        IVectorService vectorService = service;
        for (String layerName : vectorService.getLayerMap().keySet()) {
            LayerFilter layer;
            layer = (ILayer)vectorService.getLayerMap().get(layerName);
            boolean hasLabel = layer.isHaveLabel();
            Label layerLabel = layer.getLabel();
            for (Integer level : layer.getLevelMap().keySet()) {
                if (level < beginLevel || level > endLevel) continue;
                Map<String, String> levelFilters = levelDataFilters.get(Integer.toString(level));
                String filter = levelFilters.get(layerName);
                String labelFilter = levelFilters.get(layerName + LayerBean.LABEL_SUFFIX);
                if (null == filter && null == labelFilter) {
                    filter = "1 = 2";
                }
                try {
                    ((ILayerLevel)layer.getLevelMap().get(level)).setFilterExpression(filter);
                    if (!hasLabel || null == labelFilter) continue;
                    HashMap<String, String> llfilters = layerLabel.getLevelFilters();
                    if (null == llfilters) {
                        llfilters = new HashMap<String, String>();
                        layerLabel.setLevelFilters(llfilters);
                    }
                    llfilters.put(String.valueOf(level), labelFilter);
                }
                catch (Exception e) {
                    LOG.warn("\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u51fa\u9519\uff1a", (Throwable)e);
                }
            }
        }
    }

    private static void addFilterToMap(String strLevel, String layerName, String filterStr) {
        Map<String, String> layerFiltersAtLevel = levelDataFilters.get(strLevel);
        if (null == layerFiltersAtLevel) {
            layerFiltersAtLevel = new HashMap<String, String>();
            levelDataFilters.put(strLevel, layerFiltersAtLevel);
        }
        layerFiltersAtLevel.put(layerName, filterStr);
    }

    private static void cutMapWithUTFGrid() throws Exception {
        l1 = 7;
        l2 = 8;
        TileServerCutTask task1 = new TileServerCutTask(service.getId(), service, (IGridSystem)grid, tileMogoDS, Integer.valueOf(l1), Integer.valueOf(l2));
        int l3 = 4;
        int l4 = 6;
        String mergeFields = "id";
        UtfgridInfoBean utfgridInfoBean = new UtfgridInfoBean(Integer.valueOf(1), mergeFields, null, null, null);
        UtfgridInfoShell utfgridInfo = new UtfgridInfoShell(client, utfgridInfoBean);
        service.addUtfgridInfo((IUtfgridInfo)utfgridInfo);
        CountDownLatch latch = new CountDownLatch(1);
        UtfgridTileCutTask task2 = new UtfgridTileCutTask(service.getId(), service, tileMogoDS, Integer.valueOf(l3), Integer.valueOf(l4));
        String layerDataName = ((ILayer)service.getLayerMap().values().iterator().next()).getDataServiceId();
        task2.setPickDataServiceId(layerDataName);
        latch = new CountDownLatch(1);
        TaskLauncher.launchTask((AbstractTileDispatchTask)task2, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== UTF\u63d0\u53d6\u7ed3\u675f ==========");
        System.exit(0);
    }

    static {
        mapName = "shp2024-v20";
        levelDataFilters = new HashMap<String, Map<String, String>>();
    }
}

