/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.github.javaparser.utils.Log;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.QuadtreeGrid;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.northpool.tiledispatch.task.task.update.TileServerUpdateTask;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.cuttask.TaskLauncher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTask {
    private static Logger LOG = LoggerFactory.getLogger(UpdateTask.class);
    static Client client;
    static IVectorServiceManager svcmanager;
    static IVectorService service;
    static MongodbDataSource tileMogoDS;
    static QuadtreeGrid grid;
    static CountDownLatch latch;
    static String tileSvcName;
    static ConfBean conf;
    static int l1;
    static int l2;
    static Map<String, Map<String, String>> levelDataFilters;

    public static void main(String[] args) {
        try {
            tileSvcName = "zjvmap_2023_net";
            UpdateTask.setUp();
            UpdateTask.updateTask();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        int poolSize = 300;
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        GlobalTileSettings.bAccurateIntersect = true;
        conf = new ConfBean();
        client = new Client(UpdateTask.conf.mogoBuziDB, UpdateTask.conf.zkUrl, UpdateTask.conf.mapserverUrl);
        svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(tileSvcName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + tileSvcName);
        }
        IDataSourceInService datasource = (IDataSourceInService)client.getDataSourcesManager().get(UpdateTask.conf.mogoTileDbId);
        tileMogoDS = (MongodbDataSource)datasource.getBean();
        System.out.println("=== config completed ===");
    }

    public static void updateTask() throws Exception {
        long timestamp = System.currentTimeMillis();
        String layerName = "\u9762\u72b6\u5c45\u6c11\u5730";
        String wkt = "POLYGON((119.47264948791 29.506271190054, 119.47264948791 29.526055163747003, 119.49869910187 29.526055163747003, 119.49869910187 29.506271190054, 119.47264948791 29.506271190054))";
        HashMap wktMap = new HashMap();
        ArrayList<String> wktList = new ArrayList<String>();
        wktList.add(wkt);
        wktMap.put(layerName, wktList);
        TileServerUpdateTask task = new TileServerUpdateTask(service.getId(), service, (IGridSystem)grid, wktMap, Long.valueOf(timestamp));
        boolean isUpdateRemoveOldTile = false;
        if (isUpdateRemoveOldTile) {
            task.setRemoveOldTile(true);
        }
        latch = new CountDownLatch(1);
        TaskLauncher.launchTask((AbstractTileDispatchTask)task, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== \u5207\u7247\u6d4b\u8bd5\u7ed3\u675f ==========");
        System.exit(0);
    }

    static {
        grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
        l1 = 7;
        l2 = 14;
        levelDataFilters = new HashMap<String, Map<String, String>>();
    }
}

