/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.github.javaparser.utils.Log;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.command.QueryFilter;
import com.northpool.service.client.Client;
import com.northpool.service.manager.font.IFontManager;
import com.sfg.debugger.config.ConfBean;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontHelp {
    private static Logger LOG = LoggerFactory.getLogger(FontHelp.class);
    static Client client;
    static IFontManager fontMan;

    public static void main(String[] args) {
        try {
            FontHelp.setUp();
            FontHelp.showFontsMap();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFontFile() {
        String filename = "D:\\Atlas2022\\Git-vtile\\Publish\\\u6e32\u67d3\u5f15\u64ce\u540e\u7aef\u5b57\u4f53\\REEJI-Cutie-GB_\u9510\u5b57\u6e29\u5e05\u53ef\u7231\u7b80.ttf";
        filename = "E:\\Vtile-\u77e2\u91cf\u74e6\u7247\u4ea7\u54c1\u6587\u6863\\\u5b57\u4f53\u5927\u5168\\fonts\\GlowSansSCHeavy.ttf";
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            Font fontObj = Font.createFont(0, fis);
            String fontName = fontObj.getFontName();
            System.out.println("\u5b57\u4f53\u540d\u79f0\uff1a" + fontName);
            String json = JSON.toJSONString((Object)fontObj, (boolean)true);
            System.out.println("\u5b57\u4f53\u4fe1\u606f\uff1a" + json);
            StringBuffer str = new StringBuffer("\u82f1\u6587 family: " + fontObj.getFamily(Locale.ENGLISH));
            str.append("\n\u4e2d\u6587 family: ").append(fontObj.getFamily(Locale.CHINA));
            str.append("\nname: ").append(fontObj.getName());
            str.append("\n\u82f1\u6587 fontName: ").append(fontObj.getFontName(Locale.US));
            str.append("\n\u4e2d\u6587 fontName: ").append(fontObj.getFontName(Locale.CHINA));
            str.append(String.format("\nPlain: %b, Bold: %b, Italic: %b", fontObj.isPlain(), fontObj.isBold(), fontObj.isItalic()));
            str.append("\n\u6587\u5b57\u4e2a\u6570\uff1a").append(fontObj.getNumGlyphs());
            LOG.info("\u5b57\u4f53\u5143\u6570\u636e\uff1a\n" + str);
        }
        catch (Exception ex) {
            LOG.error("\u52a0\u8f7d\u5b57\u4f53\u6587\u4ef6\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void showFontsMap() {
        String strJson = fontMan.fontsMap(null);
        Map fontMap = (Map)JSON.parseObject((String)strJson, Map.class);
        System.out.println(JSON.toJSONString((Object)fontMap, (boolean)true));
    }

    private static void showFontList() {
        List fonts = fontMan.list(QueryFilter.getInstance());
        System.out.println(JSON.toJSONString((Object)fonts, (boolean)true));
    }

    private static void showFonts() {
        List fonts = fontMan.findAll();
        System.out.println("\u81ea\u5b9a\u4e49\u5b57\u4f53\u4e2a\u6570\uff1a " + fonts.size());
        List fontlist = fonts.stream().map(f -> f.getFamily() + " -> " + f.getFilename()).collect(Collectors.toList());
        SimplePropertyPreFilter fieldFilter = new SimplePropertyPreFilter(new String[0]);
        fieldFilter.getExcludes().add("bean");
        System.out.println(JSON.toJSONString(fontlist, (SerializeFilter)fieldFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
    }

    private static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        ConfBean conf = new ConfBean();
        client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl);
        fontMan = client.getFontManager();
        System.out.println("=== config completed ===");
    }
}

