/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.github.javaparser.utils.Log;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.enums.LAYER_TYPE;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.QuadtreeGrid;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.northpool.tiledispatch.task.task.TileLayerCutTask;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.cuttask.TaskLauncher;
import com.sfg.debugger.cuttask.UpdateTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLayerCut {
    private static Logger LOG = LoggerFactory.getLogger(UpdateTask.class);
    static Client client;
    static MongodbDataSource tileMogoDS;
    static QuadtreeGrid grid;
    static CountDownLatch latch;
    static IVectorServiceManager svcmanager;
    static IVectorService service;
    static ConfBean conf;
    static int l1;
    static int l2;
    static String dataSvcId;

    public static void main(String[] args) {
        try {
            DataLayerCut.setUp();
            DataLayerCut.cutDataLayer();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        int poolSize = 300;
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        GlobalTileSettings.bAccurateIntersect = true;
        conf = new ConfBean();
        client = new Client(DataLayerCut.conf.mogoBuziDB, DataLayerCut.conf.zkUrl, DataLayerCut.conf.mapserverUrl);
        svcmanager = client.getVectorServiceManager();
        IDataSourceInService datasource = (IDataSourceInService)client.getDataSourcesManager().get(DataLayerCut.conf.mogoTileDbId);
        tileMogoDS = (MongodbDataSource)datasource.getBean();
        System.out.println("=== config completed ===");
    }

    public static void cutDataLayer() throws Exception {
        service = (IVectorService)svcmanager.get(dataSvcId);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + dataSvcId);
        }
        long timestamp = System.currentTimeMillis();
        ILayer layer = (ILayer)service.getLayerMap().values().iterator().next();
        String bbox = service.getBbox();
        String layerName = layer.getBean().getId();
        LOG.info("\u6570\u636e\u670d\u52a1\u51c6\u5907\u5207\u7247\uff0c\u56fe\u5c42\u540d\u79f0\uff1a" + layerName + "\n bbox: " + bbox);
        TileLayerCutTask task = new TileLayerCutTask("\u6570\u636e\u670d\u52a1\uff1a" + layerName + " " + dataSvcId, layer, (IGridSystem)grid, tileMogoDS, Integer.valueOf(l1), Integer.valueOf(l2), LAYER_TYPE.layer, bbox);
        latch = new CountDownLatch(1);
        TaskLauncher.launchTask((AbstractTileDispatchTask)task, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== \u5207\u7247\u6d4b\u8bd5\u7ed3\u675f ==========");
        System.exit(0);
    }

    static {
        grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
        l1 = 6;
        l2 = 11;
        dataSvcId = "6b56d8227e7749b4a080f825b7b4d7c3";
    }
}

