/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;

public class ABC {
    public static void main(String[] args) {
        ABC.getClassDir();
    }

    private static void getClassDir() {
        ClassLoader classLoader = ABC.class.getClassLoader();
        URL location = classLoader.getResource(ABC.class.getName().replace('.', '/') + ".class");
        if (location != null) {
            System.out.println("\u5f53\u524d\u7c7b\u6587\u4ef6\u4f4d\u7f6e\uff1a" + location.getFile());
        } else {
            System.err.println("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7c7b\u6587\u4ef6\u4f4d\u7f6e");
        }
        System.out.println("usr.dir:  " + System.getProperty("user.dir"));
    }

    private static void futureTimeoutExample() {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(5000L);
                future.complete("Task completed successfully.");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        try {
            String result = (String)future.get();
            System.out.println("Result: " + result);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            System.out.println("Task did not complete within the specified time.");
        }
    }

    private static void testJoin() {
        double[] abc = new double[]{1.0, 2.0, 3.73};
        String ss = StringUtils.join((double[])abc, (char)' ');
        System.out.println(ss);
    }

    private static void testSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("\u5143\u7d201");
        set.add("\u5143\u7d202");
        set.add("\u5143\u7d201");
        set.add(null);
        System.out.println("set\u4e2d\u7684\u6240\u6709\u5143\u7d20\uff1a");
        for (String element : set) {
            System.out.println(element);
        }
        String target = "\u5143\u7d202";
        System.out.println("set\u4e2d\u5305\u542b\u5b57\u7b26\u4e32\uff1a" + set.contains(target));
    }

    private static void makeSvgSymbols() {
        String style = "day";
        style = "day";
        String cssStyle = ABC.getStyle(style);
        String svgSrcPath = "E:\\Data\\S57\\\u7b26\u53f7\\Symbols\\Symbols";
        String svgTargetPath = svgSrcPath + "_" + style;
        String[] svgFiles = new File(svgSrcPath).list((dir, name) -> name.toLowerCase().endsWith(".svg"));
        int nNum = svgFiles.length;
        System.out.println("\u5171\u6709" + nNum + "\u4e2aSVG\u7b26\u53f7\uff01");
        for (String f : svgFiles) {
            ABC.processFile(svgSrcPath + "\\" + f, svgTargetPath, cssStyle);
        }
        System.out.println("\u8f6c\u5316\u5b8c\u6210\uff01");
    }

    private static void processFile(String fname, String svgTargetPath, String cssStyle) {
        try {
            String line;
            File f = new File(fname);
            if (!f.exists()) {
                return;
            }
            File destDir = new File(svgTargetPath);
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            BufferedReader br = new BufferedReader(new FileReader(fname));
            BufferedWriter bw = new BufferedWriter(new FileWriter(svgTargetPath + "\\" + f.getName()));
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (3 == ++i && line.endsWith("</title>")) {
                    line = "\n" + cssStyle + "\n" + line;
                }
                bw.write(line);
                bw.write("\n");
            }
            bw.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getStyle(String t) {
        String css = "<style>";
        switch (t) {
            case "day": {
                css = ".svg {background-color: #93AEBB;color: #E38039;}.layout {display:none}.symbolBox {stroke:black;stroke-width:0.32;}.svgBox {stroke:blue;stroke-width:0.32;}.pivotPoint {stroke:red;stroke-width:0.64;}.sl {stroke-linecap:round;stroke-linejoin:round}.f0 {fill:none}.sNODTA {stroke:#93AEBB}.fNODTA {fill:#93AEBB}.sCURSR {stroke:#E38039}.fCURSR {fill:#E38039}.sCHBLK {stroke:#000000}.fCHBLK {fill:#000000}.sCHGRD {stroke:#4C5B63}.fCHGRD {fill:#4C5B63}.sCHGRF {stroke:#768C97}.fCHGRF {fill:#768C97}.sCHRED {stroke:#EA5471}.fCHRED {fill:#EA5471}.sCHGRN {stroke:#52E83B}.fCHGRN {fill:#52E83B}.sCHYLW {stroke:#E1E139}.fCHYLW {fill:#E1E139}.sCHMGD {stroke:#C045D1}.fCHMGD {fill:#C045D1}.sCHMGF {stroke:#CBA9F9}.fCHMGF {fill:#CBA9F9}.sCHBRN {stroke:#A19653}.fCHBRN {fill:#A19653}.sCHWHT {stroke:#C9EDFF}.fCHWHT {fill:#C9EDFF}.sSCLBR {stroke:#E38039}.fSCLBR {fill:#E38039}.sCHCOR {stroke:#E38039}.fCHCOR {fill:#E38039}.sLITRD {stroke:#EA5471}.fLITRD {fill:#EA5471}.sLITGN {stroke:#52E83B}.fLITGN {fill:#52E83B}.sLITYW {stroke:#E1E139}.fLITYW {fill:#E1E139}.sISDNG {stroke:#C045D1}.fISDNG {fill:#C045D1}.sDNGHL {stroke:#EA5471}.fDNGHL {fill:#EA5471}.sTRFCD {stroke:#C045D1}.fTRFCD {fill:#C045D1}.sTRFCF {stroke:#CBA9F9}.fTRFCF {fill:#CBA9F9}.sLANDA {stroke:#BFBE8F}.fLANDA {fill:#BFBE8F}.sLANDF {stroke:#8D642E}.fLANDF {fill:#8D642E}.sCSTLN {stroke:#4C5B63}.fCSTLN {fill:#4C5B63}.sSNDG1 {stroke:#768C97}.fSNDG1 {fill:#768C97}.sSNDG2 {stroke:#000000}.fSNDG2 {fill:#000000}.sDEPSC {stroke:#4C5B63}.fDEPSC {fill:#4C5B63}.sDEPCN {stroke:#768C97}.fDEPCN {fill:#768C97}.sDEPDW {stroke:#C9EDFF}.fDEPDW {fill:#C9EDFF}.sDEPMD {stroke:#A7D9FB}.fDEPMD {fill:#A7D9FB}.sDEPMS {stroke:#82CAFF}.fDEPMS {fill:#82CAFF}.sDEPVS {stroke:#61B7FF}.fDEPVS {fill:#61B7FF}.sDEPIT {stroke:#58AF9C}.fDEPIT {fill:#58AF9C}.sRADHI {stroke:#52E83B}.fRADHI {fill:#52E83B}.sRADLO {stroke:#2F8E20}.fRADLO {fill:#2F8E20}.sARPAT {stroke:#2DA879}.fARPAT {fill:#2DA879}.sNINFO {stroke:#E38039}.fNINFO {fill:#E38039}.sRESBL {stroke:#2E7BFF}.fRESBL {fill:#2E7BFF}.sADINF {stroke:#A5A527}.fADINF {fill:#A5A527}.sRESGR {stroke:#768C97}.fRESGR {fill:#768C97}.sSHIPS {stroke:#000000}.fSHIPS {fill:#000000}.sPSTRK {stroke:#000000}.fPSTRK {fill:#000000}.sSYTRK {stroke:#768C97}.fSYTRK {fill:#768C97}.sPLRTE {stroke:#D63F24}.fPLRTE {fill:#D63F24}.sAPLRT {stroke:#E38039}.fAPLRT {fill:#E38039}.sUINFD {stroke:#000000}.fUINFD {fill:#000000}.sUINFF {stroke:#4C5B63}.fUINFF {fill:#4C5B63}.sUIBCK {stroke:#C9EDFF}.fUIBCK {fill:#C9EDFF}.sUIAFD {stroke:#61B7FF}.fUIAFD {fill:#61B7FF}.sUINFR {stroke:#EA5471}.fUINFR {fill:#EA5471}.sUINFG {stroke:#52E83B}.fUINFG {fill:#52E83B}.sUINFO {stroke:#E38039}.fUINFO {fill:#E38039}.sUINFB {stroke:#2E7BFF}.fUINFB {fill:#2E7BFF}.sUINFM {stroke:#C045D1}.fUINFM {fill:#C045D1}.sUIBDR {stroke:#4C5B63}.fUIBDR {fill:#4C5B63}.sUIAFF {stroke:#BFBE8F}.fUIAFF {fill:#BFBE8F}.sOUTLW {stroke:#000000}.fOUTLW {fill:#000000}.sOUTLL {stroke:#8D642E}.fOUTLL {fill:#8D642E}.sRES01 {stroke:#768C97}.fRES01 {fill:#768C97}.sRES02 {stroke:#768C97}.fRES02 {fill:#768C97}.sRES03 {stroke:#768C97}.fRES03 {fill:#768C97}.sBKAJ1 {stroke:#0E1315}.fBKAJ1 {fill:#0E1315}.sBKAJ2 {stroke:#1C2327}.fBKAJ2 {fill:#1C2327}.sMARBL {stroke:#0080FF}.fMARBL {fill:#0080FF}.sMARCY {stroke:#008F84}.fMARCY {fill:#008F84}.sMARMG {stroke:#C64DA6}.fMARMG {fill:#C64DA6}.sMARWH {stroke:#717F77}.fMARWH {fill:#717F77}";
                break;
            }
            case "night": {
                css = "svg {background-color: #171E21;color: #301705;}.layout {display:none}.symbolBox {stroke:black;stroke-width:0.32;}.svgBox {stroke:blue;stroke-width:0.32;}.pivotPoint {stroke:red;stroke-width:0.64;}.sl {stroke-linecap:round;stroke-linejoin:round}.f0 {fill:none}.sNODTA {stroke:#171E21}.fNODTA {fill:#171E21}.sCURSR {stroke:#301705}.fCURSR {fill:#301705}.sCHBLK {stroke:#252D31}.fCHBLK {fill:#252D31}.sCHGRD {stroke:#252D31}.fCHGRD {fill:#252D31}.sCHGRF {stroke:#181E21}.fCHGRF {fill:#181E21}.sCHRED {stroke:#390E16}.fCHRED {fill:#390E16}.sCHGRN {stroke:#0C3406}.fCHGRN {fill:#0C3406}.sCHYLW {stroke:#323206}.fCHYLW {fill:#323206}.sCHMGD {stroke:#411247}.fCHMGD {fill:#411247}.sCHMGF {stroke:#411247}.fCHMGF {fill:#411247}.sCHBRN {stroke:#211E0C}.fCHBRN {fill:#211E0C}.sCHWHT {stroke:#364147}.fCHWHT {fill:#364147}.sSCLBR {stroke:#301705}.fSCLBR {fill:#301705}.sCHCOR {stroke:#301705}.fCHCOR {fill:#301705}.sLITRD {stroke:#390E16}.fLITRD {fill:#390E16}.sLITGN {stroke:#0C3406}.fLITGN {fill:#0C3406}.sLITYW {stroke:#323206}.fLITYW {fill:#323206}.sISDNG {stroke:#411247}.fISDNG {fill:#411247}.sDNGHL {stroke:#390E16}.fDNGHL {fill:#390E16}.sTRFCD {stroke:#411247}.fTRFCD {fill:#411247}.sTRFCF {stroke:#411247}.fTRFCF {fill:#411247}.sLANDA {stroke:#17160E}.fLANDA {fill:#17160E}.sLANDF {stroke:#2F1F0A}.fLANDF {fill:#2F1F0A}.sCSTLN {stroke:#252D31}.fCSTLN {fill:#252D31}.sSNDG1 {stroke:#181E21}.fSNDG1 {fill:#181E21}.sSNDG2 {stroke:#364147}.fSNDG2 {fill:#364147}.sDEPSC {stroke:#252D31}.fDEPSC {fill:#252D31}.sDEPCN {stroke:#181E21}.fDEPCN {fill:#181E21}.sDEPDW {stroke:#000000}.fDEPDW {fill:#000000}.sDEPMD {stroke:#03070A}.fDEPMD {fill:#03070A}.sDEPMS {stroke:#050E16}.fDEPMS {fill:#050E16}.sDEPVS {stroke:#071727}.fDEPVS {fill:#071727}.sDEPIT {stroke:#0B201C}.fDEPIT {fill:#0B201C}.sRADHI {stroke:#0C3406}.fRADHI {fill:#0C3406}.sRADLO {stroke:#041B02}.fRADLO {fill:#041B02}.sARPAT {stroke:#052A1B}.fARPAT {fill:#052A1B}.sNINFO {stroke:#301705}.fNINFO {fill:#301705}.sRESBL {stroke:#051B44}.fRESBL {fill:#051B44}.sADINF {stroke:#222203}.fADINF {fill:#222203}.sRESGR {stroke:#181E21}.fRESGR {fill:#181E21}.sSHIPS {stroke:#364147}.fSHIPS {fill:#364147}.sPSTRK {stroke:#364147}.fPSTRK {fill:#364147}.sSYTRK {stroke:#181E21}.fSYTRK {fill:#181E21}.sPLRTE {stroke:#330803}.fPLRTE {fill:#330803}.sAPLRT {stroke:#301705}.fAPLRT {fill:#301705}.sUINFD {stroke:#364147}.fUINFD {fill:#364147}.sUINFF {stroke:#252D31}.fUINFF {fill:#252D31}.sUIBCK {stroke:#000000}.fUIBCK {fill:#000000}.sUIAFD {stroke:#071727}.fUIAFD {fill:#071727}.sUINFR {stroke:#390E16}.fUINFR {fill:#390E16}.sUINFG {stroke:#0C3406}.fUINFG {fill:#0C3406}.sUINFO {stroke:#301705}.fUINFO {fill:#301705}.sUINFB {stroke:#051B44}.fUINFB {fill:#051B44}.sUINFM {stroke:#411247}.fUINFM {fill:#411247}.sUIBDR {stroke:#252D31}.fUIBDR {fill:#252D31}.sUIAFF {stroke:#442E12}.fUIAFF {fill:#442E12}.sOUTLW {stroke:#000000}.fOUTLW {fill:#000000}.sOUTLL {stroke:#17160E}.fOUTLL {fill:#17160E}.sRES01 {stroke:#181E21}.fRES01 {fill:#181E21}.sRES02 {stroke:#181E21}.fRES02 {fill:#181E21}.sRES03 {stroke:#181E21}.fRES03 {fill:#181E21}.sBKAJ1 {stroke:#000000}.fBKAJ1 {fill:#000000}.sBKAJ2 {stroke:#020304}.fBKAJ2 {fill:#020304}.sMARBL {stroke:#002655}.fMARBL {fill:#002655}.sMARCY {stroke:#002B27}.fMARCY {fill:#002B27}.sMARMG {stroke:#3F1333}.fMARMG {fill:#3F1333}.sMARWH {stroke:#202522}.fMARWH {fill:#202522}";
                break;
            }
            default: {
                css = "svg {background-color: #404D53;color: #86491E;}.layout {display:none}.symbolBox {stroke:black;stroke-width:0.32;}.svgBox {stroke:blue;stroke-width:0.32;}.pivotPoint {stroke:red;stroke-width:0.64;}.sl {stroke-linecap:round;stroke-linejoin:round}.f0 {fill:none}.sNODTA {stroke:#404D53}.fNODTA {fill:#404D53}.sCURSR {stroke:#86491E}.fCURSR {fill:#86491E}.sCHBLK {stroke:#6B7F89}.fCHBLK {fill:#6B7F89}.sCHGRD {stroke:#6B7F89}.fCHGRD {fill:#6B7F89}.sCHGRF {stroke:#4C5B63}.fCHGRF {fill:#4C5B63}.sCHRED {stroke:#9B3549}.fCHRED {fill:#9B3549}.sCHGRN {stroke:#2F8E20}.fCHGRN {fill:#2F8E20}.sCHYLW {stroke:#8B8B1F}.fCHYLW {fill:#8B8B1F}.sCHMGD {stroke:#826CA1}.fCHMGD {fill:#826CA1}.sCHMGF {stroke:#772782}.fCHMGF {fill:#772782}.sCHBRN {stroke:#57502A}.fCHBRN {fill:#57502A}.sCHWHT {stroke:#8CA6B3}.fCHWHT {fill:#8CA6B3}.sSCLBR {stroke:#86491E}.fSCLBR {fill:#86491E}.sCHCOR {stroke:#86491E}.fCHCOR {fill:#86491E}.sLITRD {stroke:#9B3549}.fLITRD {fill:#9B3549}.sLITGN {stroke:#2F8E20}.fLITGN {fill:#2F8E20}.sLITYW {stroke:#8B8B1F}.fLITYW {fill:#8B8B1F}.sISDNG {stroke:#826CA1}.fISDNG {fill:#826CA1}.sDNGHL {stroke:#9B3549}.fDNGHL {fill:#9B3549}.sTRFCD {stroke:#826CA1}.fTRFCD {fill:#826CA1}.sTRFCF {stroke:#772782}.fTRFCF {fill:#772782}.sLANDA {stroke:#40402E}.fLANDA {fill:#40402E}.sLANDF {stroke:#7F5A29}.fLANDF {fill:#7F5A29}.sCSTLN {stroke:#6B7F89}.fCSTLN {fill:#6B7F89}.sSNDG1 {stroke:#4C5B63}.fSNDG1 {fill:#4C5B63}.sSNDG2 {stroke:#8CA6B3}.fSNDG2 {fill:#8CA6B3}.sDEPSC {stroke:#6B7F89}.fDEPSC {fill:#6B7F89}.sDEPCN {stroke:#4C5B63}.fDEPCN {fill:#4C5B63}.sDEPDW {stroke:#000000}.fDEPDW {fill:#000000}.sDEPMD {stroke:#0F1B21}.fDEPMD {fill:#0F1B21}.sDEPMS {stroke:#1D3246}.fDEPMS {fill:#1D3246}.sDEPVS {stroke:#1E4165}.fDEPVS {fill:#1E4165}.sDEPIT {stroke:#234C44}.fDEPIT {fill:#234C44}.sRADHI {stroke:#2F8E20}.fRADHI {fill:#2F8E20}.sRADLO {stroke:#195710}.fRADLO {fill:#195710}.sARPAT {stroke:#21825C}.fARPAT {fill:#21825C}.sNINFO {stroke:#86491E}.fNINFO {fill:#86491E}.sRESBL {stroke:#1D55B4}.fRESBL {fill:#1D55B4}.sADINF {stroke:#646514}.fADINF {fill:#646514}.sRESGR {stroke:#6B7F89}.fRESGR {fill:#6B7F89}.sSHIPS {stroke:#8CA6B3}.fSHIPS {fill:#8CA6B3}.sPSTRK {stroke:#8CA6B3}.fPSTRK {fill:#8CA6B3}.sSYTRK {stroke:#4C5B63}.fSYTRK {fill:#4C5B63}.sPLRTE {stroke:#952916}.fPLRTE {fill:#952916}.sAPLRT {stroke:#86491E}.fAPLRT {fill:#86491E}.sUINFD {stroke:#8CA6B3}.fUINFD {fill:#8CA6B3}.sUINFF {stroke:#6B7F89}.fUINFF {fill:#6B7F89}.sUIBCK {stroke:#000000}.fUIBCK {fill:#000000}.sUIAFD {stroke:#1E4165}.fUIAFD {fill:#1E4165}.sUINFR {stroke:#9B3549}.fUINFR {fill:#9B3549}.sUINFG {stroke:#2F8E20}.fUINFG {fill:#2F8E20}.sUINFO {stroke:#86491E}.fUINFO {fill:#86491E}.sUINFB {stroke:#1D55B4}.fUINFB {fill:#1D55B4}.sUINFM {stroke:#826CA1}.fUINFM {fill:#826CA1}.sUIBDR {stroke:#6B7F89}.fUIBDR {fill:#6B7F89}.sUIAFF {stroke:#7F5A29}.fUIAFF {fill:#7F5A29}.sOUTLW {stroke:#000000}.fOUTLW {fill:#000000}.sOUTLL {stroke:#40402E}.fOUTLL {fill:#40402E}.sRES01 {stroke:#4C5B63}.fRES01 {fill:#4C5B63}.sRES02 {stroke:#4C5B63}.fRES02 {fill:#4C5B63}.sRES03 {stroke:#4C5B63}.fRES03 {fill:#4C5B63}.sBKAJ1 {stroke:#000000}.fBKAJ1 {fill:#000000}.sBKAJ2 {stroke:#101518}.fBKAJ2 {fill:#101518}.sMARBL {stroke:#0077F3}.fMARBL {fill:#0077F3}.sMARCY {stroke:#00857A}.fMARCY {fill:#00857A}.sMARMG {stroke:#B8479A}.fMARMG {fill:#B8479A}.sMARWH {stroke:#69766E}.fMARWH {fill:#69766E}";
            }
        }
        return "<style>" + css + "</style>";
    }
}

