/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cellv4.TileOptimizer;
import com.github.javaparser.utils.Log;
import com.sfg.debugger.grid.MyGridUtils;
import java.util.Set;
import java.util.function.Supplier;

public class CutOptimizeTest {
    private static String tileDBUrl;
    private static TileOptimizer tileOptm;

    public static void setUp() throws Exception {
        tileDBUrl = "mongodb://172.16.67.166:27017/sfgvtile2023";
        String tableName = "myshp";
        tileOptm = new TileOptimizer(tileDBUrl, tableName);
    }

    public static void main(String[] args) {
        try {
            CutOptimizeTest.setUp();
            CutOptimizeTest.loadTileKeys();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    private static void loadTileKeys() {
        int level = 10;
        long n = tileOptm.getTilesCountAtLevel(level);
        System.out.println(level + "\u7ea7\u74e6\u7247\u4e2a\u6570\uff1a" + n);
        Set tiles = tileOptm.loadTileKeys(level);
        int i = 0;
        for (String t : tiles) {
            System.out.println(++i + " " + t);
        }
    }

    private static void checkTiles() {
        long n = tileOptm.getTilesCountAtLevel(10);
        System.out.println("11\u7ea7\u74e6\u7247\u4e2a\u6570\uff1a" + n);
        String tileCode = "1661_371_12";
        System.out.println("\u662f\u5426\u5b58\u5728\u74e6\u7247: " + tileCode + " \uff1f " + tileOptm.existsTile(tileCode));
        tileCode = "207_47_9";
        System.out.println("\u662f\u5426\u5b58\u5728\u74e6\u7247: " + tileCode + " \uff1f " + tileOptm.existsTile(tileCode));
        int level = 9;
        System.out.println("\u7b2c" + level + "\u7ea7\u662f\u5426\u5b58\u5728\u74e6\u7247\uff1f " + tileOptm.hasTileAtLevel(level));
    }

    private static void testGrids() {
        GridExtent g = MyGridUtils.getGridExtent("207_46_9");
        GridExtent wildGrid = MyGridUtils.getGridExtent(413, 93, 10);
        g = MyGridUtils.getGridExtent(52, 11, 7);
        System.out.println("\u74e6\u7247" + wildGrid.getCodeXYL() + "\u662f\u5426\u4e3a " + g.getCodeXYL() + "\u7684\u5b69\u5b50\uff1f " + wildGrid.isChildOf(g));
        System.out.println("\u74e6\u7247" + wildGrid.getCodeXYL() + "\u662f\u5426\u5305\u542b\u4e8e " + g.getCodeXYL() + "\uff1f " + g.covers(wildGrid));
    }
}

