/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.commons.conf.ThreadPoolConf;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.utfgrid.IUtfgridInfo;
import com.geoway.vtile.model.vector_service.utfgrid.UtfgridInfoBean;
import com.geoway.vtile.model.vector_service.utfgrid.UtfgridInfoShell;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.resources.datasource.db.DBPoolParameter;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.task.UtfgridTileCutTask;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.github.javaparser.utils.Log;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.cuttask.TaskLauncher;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutUtfGrid {
    private static Logger LOG = LoggerFactory.getLogger(CutUtfGrid.class);
    static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
    static Client client;
    static IVectorService service;
    static MongodbDataSource tileMogoDS;
    static String mapName;
    static int l1;
    static int l2;
    static Map<String, Map<String, String>> levelDataFilters;

    public static void main(String[] args) {
        try {
            CutUtfGrid.setUp();
            CutUtfGrid.cutData();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        GlobalTileSettings.bAccurateCut = true;
        GlobalTileSettings.bAccurateIntersect = false;
        GlobalTileSettings.SHOW_ERROR_DATA = true;
        GlobalTileSettings.UTFGRID_SYNC_TIMEOUT_MILLIS = 1;
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        ThreadPoolConf.REALTIME_TILE_THREAD_COUNT = 1;
        int poolSize = 100;
        DBPoolParameter.DEFAULT.setMinIdle(1);
        DBPoolParameter.DEFAULT.setInitialSize(1);
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        client = Client.create((String)conf.mogoBuziDB, (String)conf.zkUrl, (String)conf.mapserverUrl);
        IVectorServiceManager svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(mapName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + mapName);
        }
        tileMogoDS = (MongodbDataSource)((IDataSourceInService)client.getDataSourcesManager().get(conf.mogoTileDbId)).getBean();
        System.out.println("=== config completed ===");
    }

    private static void cutData() throws Exception {
        l1 = 7;
        l2 = 13;
        IStorageInfo vtileInfo = service.getStorageInfo();
        if (null == vtileInfo) {
            throw new RuntimeException("\u5730\u56fe\u670d\u52a1\u672a\u5207\u77e2\u91cf\u74e6\u7247\uff0c\u65e0\u6cd5\u63d0\u53d6UTF");
        }
        int l3 = 7;
        int l4 = 12;
        String mergeFields = "name";
        UtfgridInfoBean utfgridInfoBean = new UtfgridInfoBean(Integer.valueOf(1), mergeFields, null, null, null);
        UtfgridInfoShell utfgridInfo = new UtfgridInfoShell(client, utfgridInfoBean);
        service.addUtfgridInfo((IUtfgridInfo)utfgridInfo);
        String taskName = mapName;
        tileMogoDS = new MongodbDataSource(new ConfBean().mogoTileDbUrl2);
        UtfgridTileCutTask task = new UtfgridTileCutTask(taskName, service, tileMogoDS, Integer.valueOf(l3), Integer.valueOf(l4));
        String layerdataId = ((ILayer)service.getLayerMap().values().iterator().next()).getDataServiceId();
        task.setPickDataServiceId(layerdataId);
        CountDownLatch latch = new CountDownLatch(1);
        TaskLauncher.launchTask((AbstractTileDispatchTask)task, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== \u5207\u7247\u6d4b\u8bd5\u7ed3\u675f ==========");
        System.exit(0);
    }

    static {
        mapName = "Shp1234";
        levelDataFilters = new HashMap<String, Map<String, String>>();
    }
}

