/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.Label;
import com.geoway.vtile.model.vector_service.layer.LayerBean;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.resources.datasource.db.DBPoolParameter;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.geoway.vtile.tiledispatch.task.v4.MapCutTaskV4;
import com.github.javaparser.utils.Log;
import com.sfg.debugger.buzidata.BuziUtil;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.config.CutConfig;
import com.sfg.debugger.cuttask.TaskLauncher;
import com.sfg.debugger.filter.LayerFilter;
import com.sfg.debugger.filter.LevelFilter;
import com.sfg.debugger.grid.MyGridUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeCutTask {
    private static Logger LOG = LoggerFactory.getLogger(ResumeCutTask.class);
    static Client client;
    static IVectorServiceManager svcmanager;
    static IVectorService service;
    static MongodbDataSource tileMogoDS;
    static QuadtreeGrid grid;
    static CountDownLatch latch;
    static String tileSvcName;
    static ConfBean conf;
    static int l1;
    static int l2;
    static Map<String, Map<String, String>> levelDataFilters;

    public static void main(String[] args) {
        tileSvcName = "hnzj";
        try {
            ResumeCutTask.setUp();
            ResumeCutTask.recutTask();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        int poolSize = 300;
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        GlobalTileSettings.bAccurateIntersect = true;
        conf = new ConfBean();
        client = Client.create((String)ResumeCutTask.conf.mogoBuziDB, (String)ResumeCutTask.conf.zkUrl, (String)ResumeCutTask.conf.mapserverUrl);
        svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(tileSvcName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + tileSvcName);
        }
        IDataSourceInService datasource = (IDataSourceInService)client.getDataSourcesManager().get(ResumeCutTask.conf.mogoTileDbId);
        tileMogoDS = (MongodbDataSource)datasource.getBean();
        System.out.println("=== config completed ===");
    }

    public static void recutTask() throws Exception {
        AbstractTileDispatchTask task = ResumeCutTask.buildTask();
        latch = new CountDownLatch(1);
        TaskLauncher.launchTask(task, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== \u5207\u7247\u6d4b\u8bd5\u7ed3\u675f ==========");
        System.exit(0);
    }

    private static AbstractTileDispatchTask buildTask() throws Exception {
        String box = service.getBbox();
        LOG.info("\u5730\u56fe\u670d\u52a1 {} \u7684\u53ef\u89c1\u8303\u56f4\uff1a{}", (Object)tileSvcName, (Object)MyGridUtils.bboxToGeometry(box));
        ResumeCutTask.addCutFiltersByStyle();
        boolean isStyleSelected = !levelDataFilters.isEmpty();
        MapCutTaskV4 task = new MapCutTaskV4(service);
        task.setPrehotOptions(tileMogoDS, l1, l2, isStyleSelected);
        return task;
    }

    private static void addCutFiltersByStyle() throws Exception {
        String svcId = service.getId();
        IVectorService vectorService = service;
        String json = BuziUtil.getCutFiltersFromPG(svcId);
        if (StringUtils.isEmpty((CharSequence)json)) {
            throw new Exception("\u672a\u627e\u5230\u670d\u52a1" + svcId + "\u7684\u5207\u7247\u65b9\u6848");
        }
        CutConfig cutcfg = (CutConfig)JSON.parseObject((String)json, CutConfig.class);
        String cacheDatasourceId = cutcfg.getCacheDatasourceId();
        int beginLevel = cutcfg.getCutLevel()[0];
        int endLevel = cutcfg.getCutLevel()[1];
        List<LevelFilter> filters = cutcfg.getStyleFilters();
        l1 = beginLevel;
        l2 = endLevel;
        if (filters == null || filters.isEmpty()) {
            return;
        }
        String LEVEL_SEPARATOR = "-";
        HashMap<String, String> filterMap = new HashMap<String, String>();
        for (LevelFilter filter : filters) {
            String strLevel = filter.getLevel();
            for (LayerFilter layer : filter.getLayers()) {
                String filterStr = layer.getFilter();
                if (StringUtils.isNotEmpty((CharSequence)filterStr)) {
                    filterStr = filterStr.replace("\"", "'");
                }
                String layerName = layer.getLayer();
                if (strLevel.contains("-")) {
                    String[] levels = strLevel.split("-");
                    int from = Integer.valueOf(levels[0]);
                    int to = Integer.valueOf(levels[1]);
                    for (int i = from; i <= to; ++i) {
                        filterMap.put(i + "-" + layerName, filterStr);
                        ResumeCutTask.addFilterToMap(i + "", layerName, filterStr);
                    }
                    continue;
                }
                filterMap.put(strLevel + "-" + layerName, filterStr);
                ResumeCutTask.addFilterToMap(strLevel, layerName, filterStr);
            }
        }
        String jsonFilters = JSON.toJSONString(levelDataFilters, (boolean)true);
        LOG.info("\u5207\u7247\u8fc7\u6ee4\u6761\u4ef6\u8868\uff1a {}", (Object)jsonFilters);
        for (String layerName : vectorService.getLayerMap().keySet()) {
            ILayer layer = (ILayer)vectorService.getLayerMap().get(layerName);
            boolean hasLabel = layer.isHaveLabel();
            Label layerLabel = layer.getLabel();
            for (Integer level : layer.getLevelMap().keySet()) {
                if (level < beginLevel || level > endLevel) continue;
                Map<String, String> levelFilters = levelDataFilters.get(Integer.toString(level));
                String filter = levelFilters.get(layerName);
                String labelFilter = levelFilters.get(layerName + LayerBean.LABEL_SUFFIX);
                if (null == filter && null == labelFilter) {
                    filter = "1 = 2";
                }
                try {
                    ((ILayerLevel)layer.getLevelMap().get(level)).setFilterExpression(filter);
                    if (!hasLabel || null == labelFilter) continue;
                    HashMap<String, String> llfilters = layerLabel.getLevelFilters();
                    if (null == llfilters) {
                        llfilters = new HashMap<String, String>();
                        layerLabel.setLevelFilters(llfilters);
                    }
                    llfilters.put(String.valueOf(level), labelFilter);
                }
                catch (Exception e) {
                    LOG.warn("\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u51fa\u9519\uff1a", (Throwable)e);
                }
            }
        }
    }

    private static void addFilterToMap(String strLevel, String layerName, String filterStr) {
        Map<String, String> layerFiltersAtLevel = levelDataFilters.get(strLevel);
        if (null == layerFiltersAtLevel) {
            layerFiltersAtLevel = new HashMap<String, String>();
            levelDataFilters.put(strLevel, layerFiltersAtLevel);
        }
        layerFiltersAtLevel.put(layerName, filterStr);
    }

    static {
        grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
        l1 = 7;
        l2 = 14;
        levelDataFilters = new HashMap<String, Map<String, String>>();
    }
}

