/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.grid;

import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.spatial.grid.extent.impl.ExtentImpl;
import com.geoway.vtile.spatial.wkt.WktDecoder;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MyGridUtils {
    public static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);

    private static void getChinaL12Grids() {
        ExtentImpl mapExt = new ExtentImpl(74.0, 21.0, 135.0, 54.0);
        int level = 12;
        List batchExt = grid.getGridExtentsByBBox(level, mapExt.getLeft(), mapExt.getBottom(), mapExt.getRight(), mapExt.getTop());
        System.out.println("BBOX\u8303\u56f4\u76d2\uff1a" + mapExt.getWkt());
        System.out.println("\u5f53\u524dBBOX\u8303\u56f4\u5185\u547d\u4e2d\u7f51\u683c\u6570\uff1a" + batchExt.size());
        try {
            String wkt = null;
            FileOutputStream fileOutputStream = null;
            File file = new File("E:\\Data\\vtile\\L12_BBoxs\\l12_china.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            for (int i1 = 0; i1 < batchExt.size(); ++i1) {
                GridExtent exti = (GridExtent)batchExt.get(i1);
                wkt = exti.getExtentByBuffer(5).getWkt();
                wkt = wkt + "\r\n";
                fileOutputStream.write(wkt.getBytes("utf-8"));
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            System.out.println("\u5df2\u5b8c\u6210\u8f93\u51fa");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void getBBoxOfGrid() {
        String wkt = null;
        wkt = MyGridUtils.getBBoxOfTileWithBuffer("27277_5608_16");
        System.out.println(wkt);
    }

    public static String getBBoxOfTileWithBuffer(String tile_code) {
        String[] parts = tile_code.split("_");
        int x = Integer.parseInt(parts[0]);
        int y = Integer.parseInt(parts[1]);
        int l = Integer.parseInt(parts[2]);
        String wkt = MyGridUtils.getBBoxOfTileWithBuffer(x, y, l);
        return wkt;
    }

    public static String getBBoxOfTileWithBuffer(int x, int y, int l) {
        GridExtent currExtent = grid.getGridExtent(l, x, y);
        int bufferSize = 5;
        currExtent.setBufferSize(Integer.valueOf(5));
        return currExtent.getExtentByBuffer(bufferSize).getWkt();
    }

    public static String getGridExtentByGeometry(String wkt) throws Exception {
        String zone = "POLYGON ((76.1044921875 39.3662109375,76.2978515625 39.3662109375,76.2978515625 39.5595703125,76.1044921875 39.5595703125,76.1044921875 39.3662109375))";
        if (StringUtils.isEmpty((CharSequence)wkt)) {
            wkt = zone;
        }
        GeoBuffer geo = WktDecoder.DECODER.toGeoBuffer(wkt);
        double[] minmaxCoord = geo.getBBOX();
        ExtentImpl ext = new ExtentImpl(minmaxCoord[0], minmaxCoord[1], minmaxCoord[2], minmaxCoord[3]);
        int level = 12;
        List batchExt = grid.getGridExtentsByBBox(level, ext.getLeft(), ext.getBottom(), ext.getRight(), ext.getTop());
        GridExtent targetOne = null;
        int count = batchExt.size();
        if (0 == count) {
            return null;
        }
        targetOne = count >= 9 ? (GridExtent)batchExt.get(count / 2 + 1) : (GridExtent)batchExt.get(0);
        String tileCode = targetOne.getCodeXYL();
        System.out.println(tileCode);
        return tileCode;
    }

    public static String bboxToGeometry(String box) throws Exception {
        String[] parts = box.split(",");
        String left = parts[0];
        String bottom = parts[1];
        String right = parts[2];
        String top = parts[3];
        String wkt = "POLYGON ((" + left + ' ' + bottom + ',' + right + ' ' + bottom + ',' + right + ' ' + top + ',' + left + ' ' + top + ',' + left + ' ' + bottom + ')' + ')';
        return wkt;
    }

    public static GridExtent getGridExtent(String x_y_z) {
        String[] args = x_y_z.split("_", 3);
        return MyGridUtils.getGridExtent(Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]));
    }

    public static GridExtent getGridExtent(int x, int y, int level) {
        return grid.getGridExtent(level, x, y);
    }
}

