/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sfg.debugger.manager.MyHTTPClient;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VTileUpdateXML {
    private static Logger logger = LoggerFactory.getLogger(VTileUpdateXML.class);
    private static MyHTTPClient httpCli = new MyHTTPClient(null, null);

    public static void main(String[] args) {
        try {
            VTileUpdateXML.testBatch1();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static void test1() throws Exception {
        VTileUpdateXML.sendUpdateRequest(VTileUpdateXML.getMapId(), VTileUpdateXML.getXmlContent());
    }

    private static void testBatch1() throws Exception {
        int nSec = 3;
        int loop = 2;
        for (int i = 0; i < loop; ++i) {
            logger.info("\u6267\u884c\u7b2c{}\u6b21\u66f4\u65b0", (Object)(i + 1));
            VTileUpdateXML.sendUpdateRequest(VTileUpdateXML.getMapId(), VTileUpdateXML.getXmlContent());
            Thread.sleep(nSec * 1000);
        }
    }

    private static String getMapId() {
        return "7fdb912fbe5d4c07b5c46761c000bf96";
    }

    private static String getXmlContent() {
        return "<Service>\n\t<Layers>\n\t\t<Layer Id=\"myshp\">\n\t\t\t<WKTS>\n\t\t\t\t<WKT>POLYGON((112.47915169591 23.851148180526003, 112.47915169591 24.903089098494, 112.96529671544 24.903089098494, 112.96529671544 23.851148180526003, 112.47915169591 23.851148180526003))</WKT>\n\t\t\t\t<WKT>POLYGON((113.13009163732 24.815198473494, 113.32784554357 23.969251207869, 113.64370247716 24.018689684432, 113.58877083654 24.263135485213, 113.46517464513 24.493848375838, 113.74532601232 24.570752672713, 113.98427864904 24.614697985213, 114.1655530631 24.782239489119, 114.01998421544 24.922315172713, 113.84420296544 24.784986071151, 113.72884652013 24.952527575057, 113.13009163732 24.815198473494))</WKT>\n\t\t\t</WKTS>\n\t\t</Layer>\n\t</Layers>\n</Service>\n";
    }

    private static Long getTimeStamp() {
        return System.currentTimeMillis();
    }

    private static String getUpdateTileUrl() {
        return "http://172.16.83.221:8084/atlas-vtile/sync/update/service/saveTask.do";
    }

    private static void sendUpdateRequest(String serviceId, String xmlStr) throws Exception {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("id", serviceId);
        payload.put("time", VTileUpdateXML.getTimeStamp());
        payload.put("type", 1);
        payload.put("xml", xmlStr);
        MyHTTPClient.HttpResult result = httpCli.postForm(VTileUpdateXML.getUpdateTileUrl(), payload);
        if (result.code != 200) {
            throw new Exception("\u8bf7\u6c42\u5931\u8d25\uff1a" + JSON.toJSONString((Object)result));
        }
        JSONObject resultObject = JSONObject.parseObject((String)result.data);
        if ("ok".equals(resultObject.getString("status"))) {
            logger.info("\u8c03\u7528\u77e2\u91cf\u74e6\u7247\u7ba1\u7406\u7cfb\u7edf\u4fdd\u5b58\u5730\u56fe\u670d\u52a1\u66f4\u65b0\u4efb\u52a1\u6210\u529f!" + result.data);
        } else {
            logger.error("\u8c03\u7528\u77e2\u91cf\u74e6\u7247\u7ba1\u7406\u7cfb\u7edf\u4fdd\u5b58\u5730\u56fe\u670d\u52a1\u66f4\u65b0\u4efb\u52a1\u5931\u8d25: " + resultObject.getString("message") + "\n\u8bf7\u6c42\u53c2\u6570\u4e3a: " + JSON.toJSONString(payload));
        }
    }
}

