/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.rtt;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.Constants;
import com.geoway.vtile.model.data_service.FieldsConfig;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.resources.MongodbDao;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.transform.tools.varint.VarintReader;
import com.geoway.vtile.transform.tools.varint.model.LayerInfoModel;
import com.github.javaparser.utils.Log;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.rtt.RealtimeTileWork;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileReader {
    private static Logger LOG = LoggerFactory.getLogger(TileReader.class);
    static Client client;
    static String mapSvcName;
    static MongodbDataSource tileMogoDS;
    static Map<String, List<FieldsConfig>> layerFieldsDict;
    static Map<String, Integer> propNumsDict;
    static boolean printCoords;

    public static void main(String[] args) {
        mapSvcName = "nullfilter";
        try {
            TileReader.setUp();
            TileReader.printTileInfo();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    private static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        ConfBean conf = new ConfBean();
        client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl, true);
        IDataSourceInService datasource = (IDataSourceInService)client.getDataSourcesManager().get(conf.mogoTileDbId);
        tileMogoDS = (MongodbDataSource)datasource.getBean();
        System.out.println("=== config completed ===");
    }

    private static void printTileInfo() throws Exception {
        String url = tileMogoDS.getUri();
        System.out.println("\u74e6\u7247\u5e93\u5730\u5740\uff1a" + url);
        String colltionName = mapSvcName;
        MongodbDao dao = tileMogoDS.factory().getDao(colltionName);
        Document query = new Document();
        query.put("fx", (Object)52);
        query.put("fy", (Object)11);
        query.put("flevel", (Object)7);
        Document tile = dao.findone((Bson)query);
        System.out.println("\u67e5\u627e\u74e6\u7247\u5b58\u5728\uff1a" + (tile != null));
        if (null == tile) {
            return;
        }
        Binary bin = (Binary)tile.get((Object)"fdata1");
        byte[] vtileData = bin.getData();
        if (null == vtileData || 0 == vtileData.length) {
            System.err.println("\u74e6\u7247\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        System.out.println("\u74e6\u7247\u5b57\u8282\u6570\uff1a" + vtileData.length);
        TileReader.printVtileData(vtileData, null);
    }

    private static void printVtileData(byte[] vtileData, String layerName) throws Exception {
        if (null == vtileData || 0 == vtileData.length) {
            return;
        }
        TileReader.getFieldsMap();
        VarintReader reader = new VarintReader(ByteBuffer.wrap(vtileData), 4, propNumsDict);
        int layerOrder = 1;
        HashMap<String, RealtimeTileWork.VTLayerVO> layerVOs = new HashMap<String, RealtimeTileWork.VTLayerVO>();
        for (String lyrName : reader.getAllLayerNames()) {
            LayerInfoModel lim = reader.getLayerFeature(lyrName);
            List attrs = reader.getLayerPro(lyrName);
            RealtimeTileWork.VTLayerVO lvo = new RealtimeTileWork.VTLayerVO();
            lvo.layerName = lyrName;
            lvo.featureCount = lim.getOffsetArray().length / 2;
            lvo.attrs = attrs;
            if (printCoords) {
                lvo.coords = reader.getAllCoordinates(lyrName, 10);
            }
            layerVOs.put(lyrName, lvo);
            System.out.println("\nlayer - " + layerOrder++);
            LOG.info("layer - {}", (Object)(layerOrder - 1));
            lvo.print();
        }
    }

    private static void getFieldsMap() {
        if (null != layerFieldsDict) {
            return;
        }
        layerFieldsDict = new LinkedHashMap<String, List<FieldsConfig>>();
        propNumsDict = new HashMap<String, Integer>();
        IVectorService service = (IVectorService)client.getVectorServiceManager().get(mapSvcName);
        service.getLayerMap().forEach((name, layer) -> {
            List lyrFields = service.getLayerFields(layer);
            layerFieldsDict.put((String)name, lyrFields);
            propNumsDict.put((String)name, lyrFields.size());
            if (layer.isHaveLabel()) {
                name = name + "_\u6ce8\u8bb0";
                layerFieldsDict.put((String)name, lyrFields);
                propNumsDict.put((String)name, lyrFields.size());
                if (Constants.LABEL_TYPE.area == layer.getLabel().getType()) {
                    propNumsDict.put((String)name, lyrFields.size() + 1);
                }
            }
        });
    }

    static {
        printCoords = false;
    }
}

