/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.analyze;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_service.IDataService;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.db.DBPoolParameter;
import com.geoway.vtile.service.client.Client;
import com.github.javaparser.utils.Log;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.utils.NaturalBreaks;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerQuery {
    private static Logger logger = LoggerFactory.getLogger(LayerQuery.class);
    static String tileSvcName = "dltb1k";
    static Client client;
    static IVectorServiceManager svcmanager;
    static IVectorService service;

    public static void main(String[] args) {
        try {
            LayerQuery.setUp();
            LayerQuery.queryMapLayer("dltb_2021_1k");
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        int poolSize = 100;
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl, true);
        svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(tileSvcName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + tileSvcName);
        }
    }

    public static List<String[]> queryPG(String sql, Connection conn) throws Exception {
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.setFetchSize(1000);
        ResultSet rs = stmt.executeQuery(sql);
        int colCount = rs.getMetaData().getColumnCount();
        String[] arr = new String[colCount];
        ArrayList<String[]> records = new ArrayList<String[]>();
        while (rs.next()) {
            String fval = "";
            for (int i = 0; i < colCount; ++i) {
                arr[i] = fval = rs.getString(i + 1);
            }
            records.add(arr);
            arr = new String[colCount];
        }
        return records;
    }

    private static void queryMapLayer(String layerName) throws Exception {
        ILayer layer = (ILayer)service.getLayerMap().get(layerName);
        if (layer == null) {
            throw new Exception("\u6ca1\u627e\u5230\u56fe\u5c42\"" + layerName + "\"");
        }
        IDataSet dataset = ((ILayerLevel)layer.getLevelMap().get(layer.getBeginLevel())).getDataSet();
        String tableName = dataset.getDataService().getTableName();
        DataSource dataSource = (DataSource)dataset.getDataSource().connection();
        Connection conn = dataSource.getConnection();
        LayerQuery.queryClassifyBreaks(conn, tableName);
    }

    private static void queryFiledValues(Connection conn, String tableName) throws Exception {
        String sql = "select count(1) from " + tableName;
        List<String[]> result = LayerQuery.queryPG(sql, conn);
        System.out.println(result.get(0)[0]);
        sql = "select tbmj from " + tableName;
        result = LayerQuery.queryPG(sql, conn);
        int ncount = result.size();
        FileWriter fileWriter = new FileWriter("double-values.txt");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        for (int i = 0; i < ncount; ++i) {
            String str = result.get(i)[0];
            bufferedWriter.write(str);
            if (i >= ncount - 1) continue;
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        fileWriter.close();
        System.out.println("\u5df2\u8f93\u51fa\u6570\u636e\u6761\u6570\uff1a" + ncount);
    }

    private static void queryDataservice(String dataName) throws Exception {
        QueryFilter filter = new QueryFilter();
        filter.addSQL("name='" + dataName + "' ");
        IDataService dsvc = (IDataService)client.getDataServiceManager().findOne(filter);
        if (null == dsvc) {
            throw new Exception("\u672a\u627e\u5230\u6570\u636e\u670d\u52a1\uff1a" + dataName);
        }
        DataSource dataSource = (DataSource)dsvc.getDataSource().connection();
        String tableName = dsvc.getTableName();
        Connection conn = dataSource.getConnection();
        LayerQuery.queryClassifyBreaks(conn, tableName);
    }

    private static void queryClassifyBreaks(Connection conn, String tableName) throws Exception {
        String sql = "select tbmj from " + tableName;
        List<String[]> result = LayerQuery.queryPG(sql, conn);
        int ncount = result.size();
        ArrayList<Double> data = new ArrayList<Double>();
        for (int i = 0; i < ncount; ++i) {
            String str = result.get(i)[0];
            data.add(Double.valueOf(str));
        }
        System.out.println("\u5df2\u5206\u6790\u6570\u636e\u6761\u6570\uff1a" + ncount);
        NaturalBreaks.FisherJenks jenks = new NaturalBreaks.FisherJenks(data, 4);
        double[] breaks = jenks.classify();
        System.out.println("\u5206\u7ea7\uff1a\n" + StringUtils.join((double[])breaks, (char)','));
    }
}

