/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.commons.conf.ThreadPoolConf;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.resources.datasource.db.DBPoolParameter;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.spatial.wkt.WktDecoder;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.task.TileServerCutTask;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.github.javaparser.utils.Log;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.cuttask.TaskLauncher;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutMapByBox {
    private static Logger LOG = LoggerFactory.getLogger(CutMapByBox.class);
    static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
    static String gridName = "tdt_degree_base512";
    static Client client;
    static IVectorServiceManager svcmanager;
    static IVectorService service;
    static MongodbDataSource tileMogoDS;
    static String mapName;

    public static void main(String[] args) {
        try {
            CutMapByBox.setUp();
            CutMapByBox.cutMap();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        GlobalTileSettings.bAccurateCut = true;
        GlobalTileSettings.bAccurateIntersect = false;
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        ThreadPoolConf.REALTIME_TILE_THREAD_COUNT = 1;
        int poolSize = 100;
        DBPoolParameter.DEFAULT.setMinIdle(1);
        DBPoolParameter.DEFAULT.setInitialSize(1);
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl, true);
        svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(mapName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + mapName);
        }
        tileMogoDS = (MongodbDataSource)((IDataSourceInService)client.getDataSourcesManager().get(conf.mogoTileDbId)).getBean();
        System.out.println("=== config completed ===");
    }

    private static void cutMap() throws Exception {
        String box = null;
        String wkt = "POLYGON ((113.18533776856 22.339608001708, 113.18533776856 23.037239837646, 114.44464562989 23.037239837646, 114.44464562989 22.339608001708, 113.18533776856 22.339608001708))";
        if (!StringUtils.isEmpty((CharSequence)wkt)) {
            GeoBuffer geo = WktDecoder.DECODER.toGeoBuffer(wkt);
            double[] minmaxCoord = geo.getBBOX();
            box = String.format("%f,%f,%f,%f", minmaxCoord[0], minmaxCoord[1], minmaxCoord[2], minmaxCoord[3]);
        }
        TileServerCutTask task = new TileServerCutTask(service.getId(), service, (IGridSystem)grid, tileMogoDS, Integer.valueOf(7), Integer.valueOf(15), box);
        TaskLauncher.launchTask((AbstractTileDispatchTask)task, null);
        Thread.sleep(1000000000000000L);
    }

    static {
        mapName = "gdoverr";
    }
}

