/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.tiledata;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_service.FieldsConfig;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.resources.datasource.db.DBPoolParameter;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.transform.service.impl.TileDataService;
import com.geoway.vtile.transform.tools.varint.VarintBuilder;
import com.geoway.vtile.transform.tools.varint.VarintReader;
import com.geoway.vtile.transform.tools.varint.model.LayerInfoModel;
import com.sfg.debugger.config.ConfBean;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeTileWork {
    private static Logger LOG = LoggerFactory.getLogger(RealtimeTileWork.class);
    static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
    static String gridName = "tdt_degree_base512";
    static Client client;
    static IVectorServiceManager svcmanager;
    static IVectorService service;
    static String mapName;
    static TileDataService tileSvc;
    static Map<String, List<FieldsConfig>> layerFieldsDict;
    static Map<String, Integer> propNumsDict;
    static boolean printCoords;

    public static void main(String[] args) {
        try {
            RealtimeTileWork.setUp();
            RealtimeTileWork.getTile();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void checkTileinfo() {
        IStorageInfo tileInfo = service.getStorageInfo();
        if (null != tileInfo && tileInfo.isCompleted().booleanValue()) {
            System.out.println("\u74e6\u7247\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)tileInfo));
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        GlobalTileSettings.bAccurateCut = true;
        GlobalTileSettings.bAccurateIntersect = false;
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        GlobalTileSettings.REALTIME_TILE_THREAD_COUNT = 1;
        GlobalTileSettings.PG_FETCH_PAGESIZE = 1000;
        int poolSize = 100;
        DBPoolParameter.DEFAULT.setMinIdle(1);
        DBPoolParameter.DEFAULT.setInitialSize(1);
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        String pgdbUrl = conf.getBusiDBUrl();
        client = Client.create((String)pgdbUrl, (String)conf.redisUrl, (String)conf.mapserverUrl);
        svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(mapName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + mapName);
        }
        System.out.println("=== config completed ===");
    }

    private static void getTile() throws Exception {
        int x = 3527;
        int y = 290;
        int z = 13;
        String layerName = "shplocal";
        String layerType = "layer";
        String filter = null;
        byte[] vtileData = tileSvc.getData(service, layerName, layerType, gridName, Integer.valueOf(x), Integer.valueOf(y), Integer.valueOf(z), filter, Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(20000));
        LOG.info("\u74e6\u7247\u5b57\u8282\u6570\uff1a {}", (Object)String.format("%,d", vtileData.length));
        RealtimeTileWork.printVtileData(vtileData, layerName);
    }

    private static void printVtileData(byte[] vtileData, String layerName) throws Exception {
        if (null == vtileData || 0 == vtileData.length) {
            return;
        }
        RealtimeTileWork.getFieldsMap();
        VarintBuilder vtBuilder = new VarintBuilder(4);
        vtBuilder.addLayerBuffer(layerName, ByteBuffer.wrap(vtileData));
        VarintReader reader = new VarintReader(vtBuilder.getVectorBuffer(), 4, propNumsDict);
        HashMap<String, VTLayerVO> layerVOs = new HashMap<String, VTLayerVO>();
        for (String lyrName : reader.getAllLayerNames()) {
            LayerInfoModel lim = reader.getLayerFeature(lyrName);
            List attrs = reader.getLayerPro(lyrName);
            VTLayerVO lvo = new VTLayerVO();
            lvo.layerName = lyrName;
            lvo.featureCount = lim.getOffsetArray().length / 2;
            lvo.attrs = attrs;
            if (printCoords) {
                lvo.coords = reader.getAllCoordinates(lyrName, 10);
            }
            layerVOs.put(lyrName, lvo);
            lvo.print();
        }
    }

    private static void getFieldsMap() {
        if (null != layerFieldsDict) {
            return;
        }
        layerFieldsDict = new LinkedHashMap<String, List<FieldsConfig>>();
        propNumsDict = new HashMap<String, Integer>();
        service.getLayerMap().forEach((name, layer) -> {
            List lyrFields = service.getLayerFields(layer);
            layerFieldsDict.put((String)name, lyrFields);
            propNumsDict.put((String)name, lyrFields.size());
        });
    }

    static {
        mapName = "56d93e0f9fc54318be6e376c95fdb42e";
        tileSvc = new TileDataService(1);
        printCoords = true;
    }

    public static class VTLayerVO {
        public String layerName;
        public int featureCount;
        public List<String[]> attrs;
        public List<double[]> coords;

        public void print() {
            LOG.info("=== {}   fetureCount: {} ====", (Object)this.layerName, (Object)this.featureCount);
            if (null == this.attrs || 0 == this.attrs.size()) {
                return;
            }
            for (int i = 0; i < this.attrs.size(); ++i) {
                Object[] rec = this.attrs.get(i);
                LOG.info("{}.\t{}", (Object)i, (Object)StringUtils.join((Object[])rec, (String)","));
                if (null == this.coords || this.coords.size() <= i) continue;
                LOG.info("\t\tCoords=> {}", (Object)JSON.toJSONString((Object)this.coords.get(i)));
            }
        }
    }
}

