/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.service.client.Client;
import com.sfg.debugger.config.ConfBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintMetadata {
    private static Logger LOG = LoggerFactory.getLogger(PrintMetadata.class);
    static Client client;
    static String mapSvcName;

    public static void main(String[] args) {
        try {
            PrintMetadata.setUp();
            PrintMetadata.printMetaInfo();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        ConfBean conf = new ConfBean();
        String pgdbUrl = conf.getBusiDBUrl();
        client = Client.create((String)pgdbUrl, (String)conf.redisUrl, (String)conf.mapserverUrl);
        System.out.println("=== config completed ===");
    }

    private static void printMetaInfo() {
        String json = PrintMetadata.getVectorServiceInfo(client, mapSvcName);
        JSONObject jobj = JSON.parseObject((String)json);
        json = JSON.toJSONString((Object)jobj, (boolean)true);
        System.out.println(json);
    }

    public static String getVectorServiceInfo(Client client, String mapServiceId) {
        IVectorServiceManager vsm = client.getVectorServiceManager();
        return vsm.getJSON(mapServiceId);
    }

    static {
        mapSvcName = "dltb";
    }
}

