/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.ogr;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.dataschema.datasource.manager.DataSourceManager;
import com.geoway.vtile.datasource.ogr.GpkgDataSource;
import com.geoway.vtile.datasource.ogr.ShapeDataSource;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.resources.datatable.dao.IMapDAO;
import java.sql.Connection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgrWork {
    private static Logger LOG = LoggerFactory.getLogger(OgrWork.class);

    public static void main(String[] args) {
        try {
            OgrWork.connGpkg();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void checkOgrClass() {
        try {
            Class<?> clazz = Class.forName("com.geoway.vtile.datasource.ogr.FGDBDataSource");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u672a\u5f15\u5165ogr\u6240\u9700jar\u5305");
        }
    }

    private static void openShp() throws Exception {
        String path = "E:\\Data\\Shp\\myshp\\myshp.shp";
        ShapeDataSource fgdbDataSource = new ShapeDataSource(path);
        String[] tables = fgdbDataSource.tables();
        ITable table = fgdbDataSource.getTable(tables[0]);
        OgrWork.printMemTable(table);
    }

    private static void spatialQuery(ITable table) {
        IMapDAO mapDAO = table.mapDao();
        String wkt = "POINT (113.279 24.209)";
        QueryFilter queryFilter = new QueryFilter();
        queryFilter.setOutputFieldNames("fid,name");
        queryFilter.setSRID(Integer.valueOf(4490));
        queryFilter.addFilter("shape", Constants.OPERATION.INTERSECTS, new Object[]{wkt});
        long start = System.currentTimeMillis();
        List m = mapDAO.query(queryFilter, Integer.valueOf(1000));
        System.out.println(System.currentTimeMillis() - start);
    }

    private static void printMemTable(ITable table) {
        IMapDAO dao = table.mapDao();
        List objs = dao.queryArray(new QueryFilter(), Integer.valueOf(1000));
        int i = 0;
        for (Object[] arr : objs) {
            String json = JSON.toJSONString((Object)arr, (boolean)true);
            System.out.println("\n" + i++ + "\n");
            System.out.println(json);
        }
    }

    private static void openGpkg() throws Exception {
        String path = "E:\\Data\\Shp\\myshp\\myshp.gpkg";
        GpkgDataSource ds = new GpkgDataSource(path);
        String[] tables = ds.tables();
        ITable table = ds.getTable(tables[0]);
        OgrWork.printMemTable(table);
    }

    private static void connGpkg() throws Exception {
        String url = "gpkg://E:\\Data\\Shp\\myshp\\myshp.gpkg";
        Connection conn = DataSourceManager.getConnection((String)url, (String)"", (String)"");
    }
}

