/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cut;

import com.geoway.vtile.commons.conf.CacheConfig;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.gdal.GDALInitializer;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_service.IDataService;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.resources.datasource.db.DBPoolParameter;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.geoway.vtile.tiledispatch.task.v4.MapCutTaskMini;
import com.github.javaparser.utils.Log;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.cut.TaskLauncher;
import com.sfg.debugger.tiledata.MyGridUtils;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutTaskMini {
    private static Logger LOG = LoggerFactory.getLogger(CutTaskMini.class);
    static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
    static Client client;
    static IVectorService service;
    static String mapName;
    static int l1;
    static int l2;

    public static void main(String[] args) {
        try {
            CutTaskMini.setUp();
            CutTaskMini.cutMap();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        GDALInitializer.initLibraries();
        GlobalTileSettings.SHOW_ERROR_DATA = true;
        CacheConfig.ENABLE_META_HTABLE_CACHE = true;
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        int poolSize = 100;
        DBPoolParameter.DEFAULT.setMinIdle(1);
        DBPoolParameter.DEFAULT.setInitialSize(1);
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        client = Client.create((String)conf.getBusiDBUrl(), (String)conf.redisUrl, (String)conf.mapserverUrl);
        System.out.println("=== config completed ===");
    }

    private static void cutMap() throws Exception {
        mapName = "gpkg";
        l1 = 7;
        l2 = 8;
        IVectorServiceManager svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(mapName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + mapName);
        }
        AbstractTileDispatchTask task = CutTaskMini.buildMapTask();
        CountDownLatch latch = new CountDownLatch(1);
        TaskLauncher.launchTask(task, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== \u5207\u7247\u6d4b\u8bd5\u7ed3\u675f ==========");
        System.exit(0);
    }

    private static AbstractTileDispatchTask buildMapTask() throws Exception {
        String box = service.getBbox();
        LOG.info("\u5730\u56fe\u670d\u52a1 {} \u7684\u53ef\u89c1\u8303\u56f4\uff1a{}", (Object)mapName, (Object)MyGridUtils.bboxToGeometry(box));
        String dsid = null;
        List dataServiceIds = service.getDataServiceIds();
        IDataService dataset = (IDataService)client.getDataServiceManager().get((String)dataServiceIds.get(0));
        dsid = dataset.getDataSourceId();
        MapCutTaskMini task = new MapCutTaskMini(service);
        task.setPrehotOptions(dsid, l1, l2, false);
        task.setEnableBatchLevel(true);
        return task;
    }

    static {
        mapName = "";
    }
}

