/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cut;

import com.geoway.vtile.manager.task.ITileDispatchTask;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.group.TileDispatchTaskGroup;
import com.geoway.vtile.tiledispatch.task.task.TileServerCutTask;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLauncher {
    private static Logger logger = LoggerFactory.getLogger(TaskLauncher.class);

    public static void launchTask(AbstractTileDispatchTask task, CountDownLatch latch) {
        if (task instanceof TileServerCutTask) {
            logger.info("\u5730\u56fe\u670d\u52a1\u5207\u7247\u4efb\u52a1\u542f\u52a8");
        }
        task.onError(() -> {
            logger.error("\u4efb\u52a1\u51fa\u9519\u4e86");
            if (null != latch) {
                latch.countDown();
            }
        });
        task.onSuccess(() -> {
            logger.info("\u4efb\u52a1\u6210\u529f");
            if (null != latch) {
                latch.countDown();
            }
        });
        task.onStart(() -> logger.info("==>\u6d4b\u8bd5\u74e6\u7247\u9884\u70ed\u4efb\u52a1\u5f00\u59cb\u5566\uff01"));
        ArrayList<AbstractTileDispatchTask> tasks = new ArrayList<AbstractTileDispatchTask>();
        tasks.add(task);
        TileDispatchTaskGroup group = new TileDispatchTaskGroup("TestTaskCutGroup", tasks);
        long start = System.currentTimeMillis();
        group.setLogger(message -> logger.info("\u300b\u300b\u300b {}", (Object)message));
        group.onError(() -> logger.error("error"));
        group.onSuccess(() -> {
            logger.info("success");
            logger.info("\u4efb\u52a1\u7ec4\u603b\u8017\u65f6ms: " + (System.currentTimeMillis() - start));
        });
        group.onStart(() -> logger.info("==>\u6d4b\u8bd5\u4efb\u52a1\u7ec4\u5f00\u59cb\u5566\uff01\uff01\uff01"));
        DoubleQueueExecutor executorService = new DoubleQueueExecutor(1);
        group.setExecutor((ExecutorService)executorService);
        group.init();
        String taskId = UUID.randomUUID().toString();
        TileDispatchTaskManager.getInstance().addTask(taskId, (ITileDispatchTask)group);
    }
}

