/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BusinessReportInterval {
    ONE_DAY("ONE_DAY"),
    ONE_WEEK("ONE_WEEK"),
    THIRTY_DAYS("THIRTY_DAYS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BusinessReportInterval> VALUE_MAP;
    private final String value;

    private BusinessReportInterval(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BusinessReportInterval fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BusinessReportInterval> knownValues() {
        EnumSet<BusinessReportInterval> knownValues = EnumSet.allOf(BusinessReportInterval.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BusinessReportInterval.class, BusinessReportInterval::toString);
    }
}

