/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkSecurityType {
    OPEN("OPEN"),
    WEP("WEP"),
    WPA_PSK("WPA_PSK"),
    WPA2_PSK("WPA2_PSK"),
    WPA2_ENTERPRISE("WPA2_ENTERPRISE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkSecurityType> VALUE_MAP;
    private final String value;

    private NetworkSecurityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkSecurityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkSecurityType> knownValues() {
        EnumSet<NetworkSecurityType> knownValues = EnumSet.allOf(NetworkSecurityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkSecurityType.class, NetworkSecurityType::toString);
    }
}

