/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse;

public class ListDeviceEventsPublisher
implements SdkPublisher<ListDeviceEventsResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final ListDeviceEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeviceEventsPublisher(AlexaForBusinessAsyncClient client, ListDeviceEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeviceEventsPublisher(AlexaForBusinessAsyncClient client, ListDeviceEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeviceEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeviceEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDeviceEventsResponseFetcher
    implements AsyncPageFetcher<ListDeviceEventsResponse> {
        private ListDeviceEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeviceEventsResponse> nextPage(ListDeviceEventsResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceEventsPublisher.this.client.listDeviceEvents(ListDeviceEventsPublisher.this.firstRequest);
            }
            return ListDeviceEventsPublisher.this.client.listDeviceEvents((ListDeviceEventsRequest)((Object)ListDeviceEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

