/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse;

public class SearchAddressBooksPublisher
implements SdkPublisher<SearchAddressBooksResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchAddressBooksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchAddressBooksPublisher(AlexaForBusinessAsyncClient client, SearchAddressBooksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchAddressBooksPublisher(AlexaForBusinessAsyncClient client, SearchAddressBooksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchAddressBooksResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchAddressBooksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchAddressBooksResponseFetcher
    implements AsyncPageFetcher<SearchAddressBooksResponse> {
        private SearchAddressBooksResponseFetcher() {
        }

        public boolean hasNextPage(SearchAddressBooksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchAddressBooksResponse> nextPage(SearchAddressBooksResponse previousPage) {
            if (previousPage == null) {
                return SearchAddressBooksPublisher.this.client.searchAddressBooks(SearchAddressBooksPublisher.this.firstRequest);
            }
            return SearchAddressBooksPublisher.this.client.searchAddressBooks((SearchAddressBooksRequest)((Object)SearchAddressBooksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

