/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;

public class SearchDevicesIterable
implements SdkIterable<SearchDevicesResponse> {
    private final AlexaForBusinessClient client;
    private final SearchDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchDevicesIterable(AlexaForBusinessClient client, SearchDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchDevicesResponseFetcher();
    }

    public Iterator<SearchDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchDevicesResponseFetcher
    implements SyncPageFetcher<SearchDevicesResponse> {
        private SearchDevicesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchDevicesResponse nextPage(SearchDevicesResponse previousPage) {
            if (previousPage == null) {
                return SearchDevicesIterable.this.client.searchDevices(SearchDevicesIterable.this.firstRequest);
            }
            return SearchDevicesIterable.this.client.searchDevices((SearchDevicesRequest)((Object)SearchDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

