/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse;

public class SearchNetworkProfilesPublisher
implements SdkPublisher<SearchNetworkProfilesResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchNetworkProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchNetworkProfilesPublisher(AlexaForBusinessAsyncClient client, SearchNetworkProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchNetworkProfilesPublisher(AlexaForBusinessAsyncClient client, SearchNetworkProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchNetworkProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchNetworkProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchNetworkProfilesResponseFetcher
    implements AsyncPageFetcher<SearchNetworkProfilesResponse> {
        private SearchNetworkProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchNetworkProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchNetworkProfilesResponse> nextPage(SearchNetworkProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchNetworkProfilesPublisher.this.client.searchNetworkProfiles(SearchNetworkProfilesPublisher.this.firstRequest);
            }
            return SearchNetworkProfilesPublisher.this.client.searchNetworkProfiles((SearchNetworkProfilesRequest)((Object)SearchNetworkProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

