/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tenant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Tenant> {
    private static final SdkField<String> TENANT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenantIdentifier").getter(Tenant.getter(Tenant::tenantIdentifier)).setter(Tenant.setter(Builder::tenantIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantIdentifier").build()}).build();
    private static final SdkField<String> TENANT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenantDisplayName").getter(Tenant.getter(Tenant::tenantDisplayName)).setter(Tenant.setter(Builder::tenantDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantDisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_IDENTIFIER_FIELD, TENANT_DISPLAY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tenantIdentifier;
    private final String tenantDisplayName;

    private Tenant(BuilderImpl builder) {
        this.tenantIdentifier = builder.tenantIdentifier;
        this.tenantDisplayName = builder.tenantDisplayName;
    }

    public final String tenantIdentifier() {
        return this.tenantIdentifier;
    }

    public final String tenantDisplayName() {
        return this.tenantDisplayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDisplayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)obj;
        return Objects.equals(this.tenantIdentifier(), other.tenantIdentifier()) && Objects.equals(this.tenantDisplayName(), other.tenantDisplayName());
    }

    public final String toString() {
        return ToString.builder((String)"Tenant").add("TenantIdentifier", (Object)this.tenantIdentifier()).add("TenantDisplayName", (Object)this.tenantDisplayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tenantIdentifier": {
                return Optional.ofNullable(clazz.cast(this.tenantIdentifier()));
            }
            case "tenantDisplayName": {
                return Optional.ofNullable(clazz.cast(this.tenantDisplayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tenant, T> g) {
        return obj -> g.apply((Tenant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantIdentifier;
        private String tenantDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(Tenant model) {
            this.tenantIdentifier(model.tenantIdentifier);
            this.tenantDisplayName(model.tenantDisplayName);
        }

        public final String getTenantIdentifier() {
            return this.tenantIdentifier;
        }

        public final void setTenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
        }

        @Override
        public final Builder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        public final String getTenantDisplayName() {
            return this.tenantDisplayName;
        }

        public final void setTenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
        }

        @Override
        public final Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            return this;
        }

        public Tenant build() {
            return new Tenant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Tenant> {
        public Builder tenantIdentifier(String var1);

        public Builder tenantDisplayName(String var1);
    }
}

