/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PardotConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PardotConnectorProfileCredentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(PardotConnectorProfileCredentials.getter(PardotConnectorProfileCredentials::accessToken)).setter(PardotConnectorProfileCredentials.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refreshToken").getter(PardotConnectorProfileCredentials.getter(PardotConnectorProfileCredentials::refreshToken)).setter(PardotConnectorProfileCredentials.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuthRequest").getter(PardotConnectorProfileCredentials.getter(PardotConnectorProfileCredentials::oAuthRequest)).setter(PardotConnectorProfileCredentials.setter(Builder::oAuthRequest)).constructor(ConnectorOAuthRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()}).build();
    private static final SdkField<String> CLIENT_CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientCredentialsArn").getter(PardotConnectorProfileCredentials.getter(PardotConnectorProfileCredentials::clientCredentialsArn)).setter(PardotConnectorProfileCredentials.setter(Builder::clientCredentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCredentialsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, REFRESH_TOKEN_FIELD, O_AUTH_REQUEST_FIELD, CLIENT_CREDENTIALS_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String refreshToken;
    private final ConnectorOAuthRequest oAuthRequest;
    private final String clientCredentialsArn;

    private PardotConnectorProfileCredentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.oAuthRequest = builder.oAuthRequest;
        this.clientCredentialsArn = builder.clientCredentialsArn;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final ConnectorOAuthRequest oAuthRequest() {
        return this.oAuthRequest;
    }

    public final String clientCredentialsArn() {
        return this.clientCredentialsArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCredentialsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PardotConnectorProfileCredentials)) {
            return false;
        }
        PardotConnectorProfileCredentials other = (PardotConnectorProfileCredentials)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.oAuthRequest(), other.oAuthRequest()) && Objects.equals(this.clientCredentialsArn(), other.clientCredentialsArn());
    }

    public final String toString() {
        return ToString.builder((String)"PardotConnectorProfileCredentials").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("RefreshToken", (Object)this.refreshToken()).add("OAuthRequest", (Object)this.oAuthRequest()).add("ClientCredentialsArn", (Object)(this.clientCredentialsArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "oAuthRequest": {
                return Optional.ofNullable(clazz.cast(this.oAuthRequest()));
            }
            case "clientCredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.clientCredentialsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PardotConnectorProfileCredentials, T> g) {
        return obj -> g.apply((PardotConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private String refreshToken;
        private ConnectorOAuthRequest oAuthRequest;
        private String clientCredentialsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PardotConnectorProfileCredentials model) {
            this.accessToken(model.accessToken);
            this.refreshToken(model.refreshToken);
            this.oAuthRequest(model.oAuthRequest);
            this.clientCredentialsArn(model.clientCredentialsArn);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return this.oAuthRequest != null ? this.oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        public final String getClientCredentialsArn() {
            return this.clientCredentialsArn;
        }

        public final void setClientCredentialsArn(String clientCredentialsArn) {
            this.clientCredentialsArn = clientCredentialsArn;
        }

        @Override
        public final Builder clientCredentialsArn(String clientCredentialsArn) {
            this.clientCredentialsArn = clientCredentialsArn;
            return this;
        }

        public PardotConnectorProfileCredentials build() {
            return new PardotConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PardotConnectorProfileCredentials> {
        public Builder accessToken(String var1);

        public Builder refreshToken(String var1);

        public Builder oAuthRequest(ConnectorOAuthRequest var1);

        default public Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return this.oAuthRequest((ConnectorOAuthRequest)((ConnectorOAuthRequest.Builder)ConnectorOAuthRequest.builder().applyMutation(oAuthRequest)).build());
        }

        public Builder clientCredentialsArn(String var1);
    }
}

