/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClient;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClientBuilder;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingServiceClientConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.DefaultApplicationAutoScalingAsyncClient;
import software.amazon.awssdk.services.applicationautoscaling.DefaultApplicationAutoScalingBaseClientBuilder;
import software.amazon.awssdk.services.applicationautoscaling.endpoints.ApplicationAutoScalingEndpointProvider;

@SdkInternalApi
final class DefaultApplicationAutoScalingAsyncClientBuilder
extends DefaultApplicationAutoScalingBaseClientBuilder<ApplicationAutoScalingAsyncClientBuilder, ApplicationAutoScalingAsyncClient>
implements ApplicationAutoScalingAsyncClientBuilder {
    DefaultApplicationAutoScalingAsyncClientBuilder() {
    }

    @Override
    public DefaultApplicationAutoScalingAsyncClientBuilder endpointProvider(ApplicationAutoScalingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApplicationAutoScalingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultApplicationAutoScalingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ApplicationAutoScalingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultApplicationAutoScalingAsyncClient client = new DefaultApplicationAutoScalingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ApplicationAutoScalingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ApplicationAutoScalingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

