/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryAsyncClient;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryAsyncClientBuilder;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryServiceClientConfiguration;
import software.amazon.awssdk.services.applicationdiscovery.DefaultApplicationDiscoveryAsyncClient;
import software.amazon.awssdk.services.applicationdiscovery.DefaultApplicationDiscoveryBaseClientBuilder;
import software.amazon.awssdk.services.applicationdiscovery.endpoints.ApplicationDiscoveryEndpointProvider;

@SdkInternalApi
final class DefaultApplicationDiscoveryAsyncClientBuilder
extends DefaultApplicationDiscoveryBaseClientBuilder<ApplicationDiscoveryAsyncClientBuilder, ApplicationDiscoveryAsyncClient>
implements ApplicationDiscoveryAsyncClientBuilder {
    DefaultApplicationDiscoveryAsyncClientBuilder() {
    }

    @Override
    public DefaultApplicationDiscoveryAsyncClientBuilder endpointProvider(ApplicationDiscoveryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApplicationDiscoveryAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultApplicationDiscoveryAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ApplicationDiscoveryServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultApplicationDiscoveryAsyncClient client = new DefaultApplicationDiscoveryAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ApplicationDiscoveryServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ApplicationDiscoveryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

