/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteAgentErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteAgentError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDeleteAgentError> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(BatchDeleteAgentError.getter(BatchDeleteAgentError::agentId)).setter(BatchDeleteAgentError.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(BatchDeleteAgentError.getter(BatchDeleteAgentError::errorMessage)).setter(BatchDeleteAgentError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(BatchDeleteAgentError.getter(BatchDeleteAgentError::errorCodeAsString)).setter(BatchDeleteAgentError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentId;
    private final String errorMessage;
    private final String errorCode;

    private BatchDeleteAgentError(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final DeleteAgentErrorCode errorCode() {
        return DeleteAgentErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteAgentError)) {
            return false;
        }
        BatchDeleteAgentError other = (BatchDeleteAgentError)obj;
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteAgentError").add("AgentId", (Object)this.agentId()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteAgentError, T> g) {
        return obj -> g.apply((BatchDeleteAgentError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentId;
        private String errorMessage;
        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteAgentError model) {
            this.agentId(model.agentId);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(DeleteAgentErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public BatchDeleteAgentError build() {
            return new BatchDeleteAgentError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDeleteAgentError> {
        public Builder agentId(String var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(DeleteAgentErrorCode var1);
    }
}

