/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshAsyncClient;
import software.amazon.awssdk.services.appmesh.internal.UserAgentUtils;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteRef;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse;

public class ListGatewayRoutesPublisher
implements SdkPublisher<ListGatewayRoutesResponse> {
    private final AppMeshAsyncClient client;
    private final ListGatewayRoutesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGatewayRoutesPublisher(AppMeshAsyncClient client, ListGatewayRoutesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGatewayRoutesPublisher(AppMeshAsyncClient client, ListGatewayRoutesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGatewayRoutesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGatewayRoutesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GatewayRouteRef> gatewayRoutes() {
        Function<ListGatewayRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.gatewayRoutes() != null) {
                return response.gatewayRoutes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGatewayRoutesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGatewayRoutesResponseFetcher
    implements AsyncPageFetcher<ListGatewayRoutesResponse> {
        private ListGatewayRoutesResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGatewayRoutesResponse> nextPage(ListGatewayRoutesResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayRoutesPublisher.this.client.listGatewayRoutes(ListGatewayRoutesPublisher.this.firstRequest);
            }
            return ListGatewayRoutesPublisher.this.client.listGatewayRoutes((ListGatewayRoutesRequest)((Object)ListGatewayRoutesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

