/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.FunctionsIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineConfig> {
    private static final SdkField<List<String>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functions").getter(PipelineConfig.getter(PipelineConfig::functions)).setter(PipelineConfig.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> functions;

    private PipelineConfig(BuilderImpl builder) {
        this.functions = builder.functions;
    }

    public final boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructList);
    }

    public final List<String> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctions() ? this.functions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineConfig)) {
            return false;
        }
        PipelineConfig other = (PipelineConfig)obj;
        return this.hasFunctions() == other.hasFunctions() && Objects.equals(this.functions(), other.functions());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineConfig").add("Functions", this.hasFunctions() ? this.functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineConfig, T> g) {
        return obj -> g.apply((PipelineConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineConfig model) {
            this.functions(model.functions);
        }

        public final Collection<String> getFunctions() {
            if (this.functions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functions;
        }

        public final void setFunctions(Collection<String> functions) {
            this.functions = FunctionsIdsCopier.copy(functions);
        }

        @Override
        public final Builder functions(Collection<String> functions) {
            this.functions = FunctionsIdsCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(String ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        public PipelineConfig build() {
            return new PipelineConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineConfig> {
        public Builder functions(Collection<String> var1);

        public Builder functions(String ... var1);
    }
}

