/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutorState {
    CREATING("CREATING"),
    CREATED("CREATED"),
    REGISTERED("REGISTERED"),
    TERMINATING("TERMINATING"),
    TERMINATED("TERMINATED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutorState> VALUE_MAP;
    private final String value;

    private ExecutorState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutorState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutorState> knownValues() {
        EnumSet<ExecutorState> knownValues = EnumSet.allOf(ExecutorState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutorState.class, ExecutorState::toString);
    }
}

