/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ForecastDataType {
    CAPACITY_FORECAST("CapacityForecast"),
    LOAD_FORECAST("LoadForecast"),
    SCHEDULED_ACTION_MIN_CAPACITY("ScheduledActionMinCapacity"),
    SCHEDULED_ACTION_MAX_CAPACITY("ScheduledActionMaxCapacity"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ForecastDataType> VALUE_MAP;
    private final String value;

    private ForecastDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ForecastDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ForecastDataType> knownValues() {
        EnumSet<ForecastDataType> knownValues = EnumSet.allOf(ForecastDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ForecastDataType.class, ForecastDataType::toString);
    }
}

