/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.ConditionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Condition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Condition> {
    private static final SdkField<String> CONDITION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionType").getter(Condition.getter(Condition::conditionTypeAsString)).setter(Condition.setter(Builder::conditionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionType").build()}).build();
    private static final SdkField<String> CONDITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionKey").getter(Condition.getter(Condition::conditionKey)).setter(Condition.setter(Builder::conditionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionKey").build()}).build();
    private static final SdkField<String> CONDITION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionValue").getter(Condition.getter(Condition::conditionValue)).setter(Condition.setter(Builder::conditionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_TYPE_FIELD, CONDITION_KEY_FIELD, CONDITION_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conditionType;
    private final String conditionKey;
    private final String conditionValue;

    private Condition(BuilderImpl builder) {
        this.conditionType = builder.conditionType;
        this.conditionKey = builder.conditionKey;
        this.conditionValue = builder.conditionValue;
    }

    public final ConditionType conditionType() {
        return ConditionType.fromValue(this.conditionType);
    }

    public final String conditionTypeAsString() {
        return this.conditionType;
    }

    public final String conditionKey() {
        return this.conditionKey;
    }

    public final String conditionValue() {
        return this.conditionValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.conditionTypeAsString(), other.conditionTypeAsString()) && Objects.equals(this.conditionKey(), other.conditionKey()) && Objects.equals(this.conditionValue(), other.conditionValue());
    }

    public final String toString() {
        return ToString.builder((String)"Condition").add("ConditionType", (Object)this.conditionTypeAsString()).add("ConditionKey", (Object)this.conditionKey()).add("ConditionValue", (Object)this.conditionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConditionType": {
                return Optional.ofNullable(clazz.cast(this.conditionTypeAsString()));
            }
            case "ConditionKey": {
                return Optional.ofNullable(clazz.cast(this.conditionKey()));
            }
            case "ConditionValue": {
                return Optional.ofNullable(clazz.cast(this.conditionValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conditionType;
        private String conditionKey;
        private String conditionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.conditionType(model.conditionType);
            this.conditionKey(model.conditionKey);
            this.conditionValue(model.conditionValue);
        }

        public final String getConditionType() {
            return this.conditionType;
        }

        public final void setConditionType(String conditionType) {
            this.conditionType = conditionType;
        }

        @Override
        public final Builder conditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        @Override
        public final Builder conditionType(ConditionType conditionType) {
            this.conditionType(conditionType == null ? null : conditionType.toString());
            return this;
        }

        public final String getConditionKey() {
            return this.conditionKey;
        }

        public final void setConditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
        }

        @Override
        public final Builder conditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
            return this;
        }

        public final String getConditionValue() {
            return this.conditionValue;
        }

        public final void setConditionValue(String conditionValue) {
            this.conditionValue = conditionValue;
        }

        @Override
        public final Builder conditionValue(String conditionValue) {
            this.conditionValue = conditionValue;
            return this;
        }

        public Condition build() {
            return new Condition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Condition> {
        public Builder conditionType(String var1);

        public Builder conditionType(ConditionType var1);

        public Builder conditionKey(String var1);

        public Builder conditionValue(String var1);
    }
}

