/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.ReportJob;
import software.amazon.awssdk.services.backup.model.ReportJobListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReportJobsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListReportJobsResponse> {
    private static final SdkField<List<ReportJob>> REPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReportJobs").getter(ListReportJobsResponse.getter(ListReportJobsResponse::reportJobs)).setter(ListReportJobsResponse.setter(Builder::reportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReportJobsResponse.getter(ListReportJobsResponse::nextToken)).setter(ListReportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ReportJob> reportJobs;
    private final String nextToken;

    private ListReportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.reportJobs = builder.reportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReportJobs() {
        return this.reportJobs != null && !(this.reportJobs instanceof SdkAutoConstructList);
    }

    public final List<ReportJob> reportJobs() {
        return this.reportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportJobs() ? this.reportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportJobsResponse)) {
            return false;
        }
        ListReportJobsResponse other = (ListReportJobsResponse)((Object)obj);
        return this.hasReportJobs() == other.hasReportJobs() && Objects.equals(this.reportJobs(), other.reportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReportJobsResponse").add("ReportJobs", this.hasReportJobs() ? this.reportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportJobs": {
                return Optional.ofNullable(clazz.cast(this.reportJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportJobsResponse, T> g) {
        return obj -> g.apply((ListReportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<ReportJob> reportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportJobsResponse model) {
            super(model);
            this.reportJobs(model.reportJobs);
            this.nextToken(model.nextToken);
        }

        public final List<ReportJob.Builder> getReportJobs() {
            List<ReportJob.Builder> result = ReportJobListCopier.copyToBuilder(this.reportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportJobs(Collection<ReportJob.BuilderImpl> reportJobs) {
            this.reportJobs = ReportJobListCopier.copyFromBuilder(reportJobs);
        }

        @Override
        public final Builder reportJobs(Collection<ReportJob> reportJobs) {
            this.reportJobs = ReportJobListCopier.copy(reportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportJobs(ReportJob ... reportJobs) {
            this.reportJobs(Arrays.asList(reportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportJobs(Consumer<ReportJob.Builder> ... reportJobs) {
            this.reportJobs(Stream.of(reportJobs).map(c -> (ReportJob)((ReportJob.Builder)ReportJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReportJobsResponse build() {
            return new ListReportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReportJobsResponse> {
        public Builder reportJobs(Collection<ReportJob> var1);

        public Builder reportJobs(ReportJob ... var1);

        public Builder reportJobs(Consumer<ReportJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

