/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.RestoreJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRestoreJobsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListRestoreJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::nextToken)).setter(ListRestoreJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::maxResults)).setter(ListRestoreJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> BY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByAccountId").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::byAccountId)).setter(ListRestoreJobsRequest.setter(Builder::byAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("accountId").build()}).build();
    private static final SdkField<Instant> BY_CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCreatedBefore").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::byCreatedBefore)).setter(ListRestoreJobsRequest.setter(Builder::byCreatedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()}).build();
    private static final SdkField<Instant> BY_CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCreatedAfter").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::byCreatedAfter)).setter(ListRestoreJobsRequest.setter(Builder::byCreatedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()}).build();
    private static final SdkField<String> BY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByStatus").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::byStatusAsString)).setter(ListRestoreJobsRequest.setter(Builder::byStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<Instant> BY_COMPLETE_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCompleteBefore").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::byCompleteBefore)).setter(ListRestoreJobsRequest.setter(Builder::byCompleteBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeBefore").build()}).build();
    private static final SdkField<Instant> BY_COMPLETE_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCompleteAfter").getter(ListRestoreJobsRequest.getter(ListRestoreJobsRequest::byCompleteAfter)).setter(ListRestoreJobsRequest.setter(Builder::byCompleteAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, BY_ACCOUNT_ID_FIELD, BY_CREATED_BEFORE_FIELD, BY_CREATED_AFTER_FIELD, BY_STATUS_FIELD, BY_COMPLETE_BEFORE_FIELD, BY_COMPLETE_AFTER_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String byAccountId;
    private final Instant byCreatedBefore;
    private final Instant byCreatedAfter;
    private final String byStatus;
    private final Instant byCompleteBefore;
    private final Instant byCompleteAfter;

    private ListRestoreJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.byAccountId = builder.byAccountId;
        this.byCreatedBefore = builder.byCreatedBefore;
        this.byCreatedAfter = builder.byCreatedAfter;
        this.byStatus = builder.byStatus;
        this.byCompleteBefore = builder.byCompleteBefore;
        this.byCompleteAfter = builder.byCompleteAfter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String byAccountId() {
        return this.byAccountId;
    }

    public final Instant byCreatedBefore() {
        return this.byCreatedBefore;
    }

    public final Instant byCreatedAfter() {
        return this.byCreatedAfter;
    }

    public final RestoreJobStatus byStatus() {
        return RestoreJobStatus.fromValue(this.byStatus);
    }

    public final String byStatusAsString() {
        return this.byStatus;
    }

    public final Instant byCompleteBefore() {
        return this.byCompleteBefore;
    }

    public final Instant byCompleteAfter() {
        return this.byCompleteAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.byAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.byStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCompleteBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCompleteAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobsRequest)) {
            return false;
        }
        ListRestoreJobsRequest other = (ListRestoreJobsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.byAccountId(), other.byAccountId()) && Objects.equals(this.byCreatedBefore(), other.byCreatedBefore()) && Objects.equals(this.byCreatedAfter(), other.byCreatedAfter()) && Objects.equals(this.byStatusAsString(), other.byStatusAsString()) && Objects.equals(this.byCompleteBefore(), other.byCompleteBefore()) && Objects.equals(this.byCompleteAfter(), other.byCompleteAfter());
    }

    public final String toString() {
        return ToString.builder((String)"ListRestoreJobsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ByAccountId", (Object)this.byAccountId()).add("ByCreatedBefore", (Object)this.byCreatedBefore()).add("ByCreatedAfter", (Object)this.byCreatedAfter()).add("ByStatus", (Object)this.byStatusAsString()).add("ByCompleteBefore", (Object)this.byCompleteBefore()).add("ByCompleteAfter", (Object)this.byCompleteAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ByAccountId": {
                return Optional.ofNullable(clazz.cast(this.byAccountId()));
            }
            case "ByCreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.byCreatedBefore()));
            }
            case "ByCreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.byCreatedAfter()));
            }
            case "ByStatus": {
                return Optional.ofNullable(clazz.cast(this.byStatusAsString()));
            }
            case "ByCompleteBefore": {
                return Optional.ofNullable(clazz.cast(this.byCompleteBefore()));
            }
            case "ByCompleteAfter": {
                return Optional.ofNullable(clazz.cast(this.byCompleteAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobsRequest, T> g) {
        return obj -> g.apply((ListRestoreJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String byAccountId;
        private Instant byCreatedBefore;
        private Instant byCreatedAfter;
        private String byStatus;
        private Instant byCompleteBefore;
        private Instant byCompleteAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.byAccountId(model.byAccountId);
            this.byCreatedBefore(model.byCreatedBefore);
            this.byCreatedAfter(model.byCreatedAfter);
            this.byStatus(model.byStatus);
            this.byCompleteBefore(model.byCompleteBefore);
            this.byCompleteAfter(model.byCompleteAfter);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getByAccountId() {
            return this.byAccountId;
        }

        public final void setByAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
        }

        @Override
        public final Builder byAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
            return this;
        }

        public final Instant getByCreatedBefore() {
            return this.byCreatedBefore;
        }

        public final void setByCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
        }

        @Override
        public final Builder byCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
            return this;
        }

        public final Instant getByCreatedAfter() {
            return this.byCreatedAfter;
        }

        public final void setByCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
        }

        @Override
        public final Builder byCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
            return this;
        }

        public final String getByStatus() {
            return this.byStatus;
        }

        public final void setByStatus(String byStatus) {
            this.byStatus = byStatus;
        }

        @Override
        public final Builder byStatus(String byStatus) {
            this.byStatus = byStatus;
            return this;
        }

        @Override
        public final Builder byStatus(RestoreJobStatus byStatus) {
            this.byStatus(byStatus == null ? null : byStatus.toString());
            return this;
        }

        public final Instant getByCompleteBefore() {
            return this.byCompleteBefore;
        }

        public final void setByCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
        }

        @Override
        public final Builder byCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
            return this;
        }

        public final Instant getByCompleteAfter() {
            return this.byCompleteAfter;
        }

        public final void setByCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
        }

        @Override
        public final Builder byCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRestoreJobsRequest build() {
            return new ListRestoreJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRestoreJobsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder byAccountId(String var1);

        public Builder byCreatedBefore(Instant var1);

        public Builder byCreatedAfter(Instant var1);

        public Builder byStatus(String var1);

        public Builder byStatus(RestoreJobStatus var1);

        public Builder byCompleteBefore(Instant var1);

        public Builder byCompleteAfter(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

