/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.CRAllocationStrategy;
import software.amazon.awssdk.services.batch.model.CRType;
import software.amazon.awssdk.services.batch.model.Ec2Configuration;
import software.amazon.awssdk.services.batch.model.Ec2ConfigurationListCopier;
import software.amazon.awssdk.services.batch.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeResource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ComputeResource.getter(ComputeResource::typeAsString)).setter(ComputeResource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allocationStrategy").getter(ComputeResource.getter(ComputeResource::allocationStrategyAsString)).setter(ComputeResource.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build()}).build();
    private static final SdkField<Integer> MINV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minvCpus").getter(ComputeResource.getter(ComputeResource::minvCpus)).setter(ComputeResource.setter(Builder::minvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minvCpus").build()}).build();
    private static final SdkField<Integer> MAXV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxvCpus").getter(ComputeResource.getter(ComputeResource::maxvCpus)).setter(ComputeResource.setter(Builder::maxvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxvCpus").build()}).build();
    private static final SdkField<Integer> DESIREDV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredvCpus").getter(ComputeResource.getter(ComputeResource::desiredvCpus)).setter(ComputeResource.setter(Builder::desiredvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredvCpus").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceTypes").getter(ComputeResource.getter(ComputeResource::instanceTypes)).setter(ComputeResource.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageId").getter(ComputeResource.getter(ComputeResource::imageId)).setter(ComputeResource.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(ComputeResource.getter(ComputeResource::subnets)).setter(ComputeResource.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(ComputeResource.getter(ComputeResource::securityGroupIds)).setter(ComputeResource.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EC2_KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2KeyPair").getter(ComputeResource.getter(ComputeResource::ec2KeyPair)).setter(ComputeResource.setter(Builder::ec2KeyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2KeyPair").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceRole").getter(ComputeResource.getter(ComputeResource::instanceRole)).setter(ComputeResource.setter(Builder::instanceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRole").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ComputeResource.getter(ComputeResource::tags)).setter(ComputeResource.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("placementGroup").getter(ComputeResource.getter(ComputeResource::placementGroup)).setter(ComputeResource.setter(Builder::placementGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementGroup").build()}).build();
    private static final SdkField<Integer> BID_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("bidPercentage").getter(ComputeResource.getter(ComputeResource::bidPercentage)).setter(ComputeResource.setter(Builder::bidPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bidPercentage").build()}).build();
    private static final SdkField<String> SPOT_IAM_FLEET_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spotIamFleetRole").getter(ComputeResource.getter(ComputeResource::spotIamFleetRole)).setter(ComputeResource.setter(Builder::spotIamFleetRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spotIamFleetRole").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchTemplate").getter(ComputeResource.getter(ComputeResource::launchTemplate)).setter(ComputeResource.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()}).build();
    private static final SdkField<List<Ec2Configuration>> EC2_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2Configuration").getter(ComputeResource.getter(ComputeResource::ec2Configuration)).setter(ComputeResource.setter(Builder::ec2Configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Configuration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ec2Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ALLOCATION_STRATEGY_FIELD, MINV_CPUS_FIELD, MAXV_CPUS_FIELD, DESIREDV_CPUS_FIELD, INSTANCE_TYPES_FIELD, IMAGE_ID_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, EC2_KEY_PAIR_FIELD, INSTANCE_ROLE_FIELD, TAGS_FIELD, PLACEMENT_GROUP_FIELD, BID_PERCENTAGE_FIELD, SPOT_IAM_FLEET_ROLE_FIELD, LAUNCH_TEMPLATE_FIELD, EC2_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String allocationStrategy;
    private final Integer minvCpus;
    private final Integer maxvCpus;
    private final Integer desiredvCpus;
    private final List<String> instanceTypes;
    private final String imageId;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String ec2KeyPair;
    private final String instanceRole;
    private final Map<String, String> tags;
    private final String placementGroup;
    private final Integer bidPercentage;
    private final String spotIamFleetRole;
    private final LaunchTemplateSpecification launchTemplate;
    private final List<Ec2Configuration> ec2Configuration;

    private ComputeResource(BuilderImpl builder) {
        this.type = builder.type;
        this.allocationStrategy = builder.allocationStrategy;
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.instanceTypes = builder.instanceTypes;
        this.imageId = builder.imageId;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.ec2KeyPair = builder.ec2KeyPair;
        this.instanceRole = builder.instanceRole;
        this.tags = builder.tags;
        this.placementGroup = builder.placementGroup;
        this.bidPercentage = builder.bidPercentage;
        this.spotIamFleetRole = builder.spotIamFleetRole;
        this.launchTemplate = builder.launchTemplate;
        this.ec2Configuration = builder.ec2Configuration;
    }

    public final CRType type() {
        return CRType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CRAllocationStrategy allocationStrategy() {
        return CRAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final Integer minvCpus() {
        return this.minvCpus;
    }

    public final Integer maxvCpus() {
        return this.maxvCpus;
    }

    public final Integer desiredvCpus() {
        return this.desiredvCpus;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypes() {
        return this.instanceTypes;
    }

    @Deprecated
    public final String imageId() {
        return this.imageId;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String ec2KeyPair() {
        return this.ec2KeyPair;
    }

    public final String instanceRole() {
        return this.instanceRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String placementGroup() {
        return this.placementGroup;
    }

    public final Integer bidPercentage() {
        return this.bidPercentage;
    }

    public final String spotIamFleetRole() {
        return this.spotIamFleetRole;
    }

    public final LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final boolean hasEc2Configuration() {
        return this.ec2Configuration != null && !(this.ec2Configuration instanceof SdkAutoConstructList);
    }

    public final List<Ec2Configuration> ec2Configuration() {
        return this.ec2Configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotIamFleetRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2Configuration() ? this.ec2Configuration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResource)) {
            return false;
        }
        ComputeResource other = (ComputeResource)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.minvCpus(), other.minvCpus()) && Objects.equals(this.maxvCpus(), other.maxvCpus()) && Objects.equals(this.desiredvCpus(), other.desiredvCpus()) && this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.imageId(), other.imageId()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.ec2KeyPair(), other.ec2KeyPair()) && Objects.equals(this.instanceRole(), other.instanceRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.bidPercentage(), other.bidPercentage()) && Objects.equals(this.spotIamFleetRole(), other.spotIamFleetRole()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && this.hasEc2Configuration() == other.hasEc2Configuration() && Objects.equals(this.ec2Configuration(), other.ec2Configuration());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeResource").add("Type", (Object)this.typeAsString()).add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("MinvCpus", (Object)this.minvCpus()).add("MaxvCpus", (Object)this.maxvCpus()).add("DesiredvCpus", (Object)this.desiredvCpus()).add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("ImageId", (Object)this.imageId()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Ec2KeyPair", (Object)this.ec2KeyPair()).add("InstanceRole", (Object)this.instanceRole()).add("Tags", this.hasTags() ? this.tags() : null).add("PlacementGroup", (Object)this.placementGroup()).add("BidPercentage", (Object)this.bidPercentage()).add("SpotIamFleetRole", (Object)this.spotIamFleetRole()).add("LaunchTemplate", (Object)this.launchTemplate()).add("Ec2Configuration", this.hasEc2Configuration() ? this.ec2Configuration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "allocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "minvCpus": {
                return Optional.ofNullable(clazz.cast(this.minvCpus()));
            }
            case "maxvCpus": {
                return Optional.ofNullable(clazz.cast(this.maxvCpus()));
            }
            case "desiredvCpus": {
                return Optional.ofNullable(clazz.cast(this.desiredvCpus()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "ec2KeyPair": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyPair()));
            }
            case "instanceRole": {
                return Optional.ofNullable(clazz.cast(this.instanceRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "placementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
            case "bidPercentage": {
                return Optional.ofNullable(clazz.cast(this.bidPercentage()));
            }
            case "spotIamFleetRole": {
                return Optional.ofNullable(clazz.cast(this.spotIamFleetRole()));
            }
            case "launchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "ec2Configuration": {
                return Optional.ofNullable(clazz.cast(this.ec2Configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeResource, T> g) {
        return obj -> g.apply((ComputeResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String allocationStrategy;
        private Integer minvCpus;
        private Integer maxvCpus;
        private Integer desiredvCpus;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String ec2KeyPair;
        private String instanceRole;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String placementGroup;
        private Integer bidPercentage;
        private String spotIamFleetRole;
        private LaunchTemplateSpecification launchTemplate;
        private List<Ec2Configuration> ec2Configuration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResource model) {
            this.type(model.type);
            this.allocationStrategy(model.allocationStrategy);
            this.minvCpus(model.minvCpus);
            this.maxvCpus(model.maxvCpus);
            this.desiredvCpus(model.desiredvCpus);
            this.instanceTypes(model.instanceTypes);
            this.imageId(model.imageId);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
            this.ec2KeyPair(model.ec2KeyPair);
            this.instanceRole(model.instanceRole);
            this.tags(model.tags);
            this.placementGroup(model.placementGroup);
            this.bidPercentage(model.bidPercentage);
            this.spotIamFleetRole(model.spotIamFleetRole);
            this.launchTemplate(model.launchTemplate);
            this.ec2Configuration(model.ec2Configuration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CRType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(CRAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final Integer getMinvCpus() {
            return this.minvCpus;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final Integer getMaxvCpus() {
            return this.maxvCpus;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final Integer getDesiredvCpus() {
            return this.desiredvCpus;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        @Deprecated
        public final String getImageId() {
            return this.imageId;
        }

        @Deprecated
        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Deprecated
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getEc2KeyPair() {
            return this.ec2KeyPair;
        }

        public final void setEc2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
        }

        @Override
        public final Builder ec2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final Integer getBidPercentage() {
            return this.bidPercentage;
        }

        public final void setBidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
        }

        @Override
        public final Builder bidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        public final String getSpotIamFleetRole() {
            return this.spotIamFleetRole;
        }

        public final void setSpotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
        }

        @Override
        public final Builder spotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final List<Ec2Configuration.Builder> getEc2Configuration() {
            List<Ec2Configuration.Builder> result = Ec2ConfigurationListCopier.copyToBuilder(this.ec2Configuration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2Configuration(Collection<Ec2Configuration.BuilderImpl> ec2Configuration) {
            this.ec2Configuration = Ec2ConfigurationListCopier.copyFromBuilder(ec2Configuration);
        }

        @Override
        public final Builder ec2Configuration(Collection<Ec2Configuration> ec2Configuration) {
            this.ec2Configuration = Ec2ConfigurationListCopier.copy(ec2Configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Configuration(Ec2Configuration ... ec2Configuration) {
            this.ec2Configuration(Arrays.asList(ec2Configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Configuration(Consumer<Ec2Configuration.Builder> ... ec2Configuration) {
            this.ec2Configuration(Stream.of(ec2Configuration).map(c -> (Ec2Configuration)((Ec2Configuration.Builder)Ec2Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ComputeResource build() {
            return new ComputeResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeResource> {
        public Builder type(String var1);

        public Builder type(CRType var1);

        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(CRAllocationStrategy var1);

        public Builder minvCpus(Integer var1);

        public Builder maxvCpus(Integer var1);

        public Builder desiredvCpus(Integer var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        @Deprecated
        public Builder imageId(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder ec2KeyPair(String var1);

        public Builder instanceRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder placementGroup(String var1);

        public Builder bidPercentage(Integer var1);

        public Builder spotIamFleetRole(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder ec2Configuration(Collection<Ec2Configuration> var1);

        public Builder ec2Configuration(Ec2Configuration ... var1);

        public Builder ec2Configuration(Consumer<Ec2Configuration.Builder> ... var1);
    }
}

