/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EksContainerDetail;
import software.amazon.awssdk.services.batch.model.EksContainerDetailsCopier;
import software.amazon.awssdk.services.batch.model.EksMetadata;
import software.amazon.awssdk.services.batch.model.EksVolume;
import software.amazon.awssdk.services.batch.model.EksVolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksPodPropertiesDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksPodPropertiesDetail> {
    private static final SdkField<String> SERVICE_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountName").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::serviceAccountName)).setter(EksPodPropertiesDetail.setter(Builder::serviceAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountName").build()}).build();
    private static final SdkField<Boolean> HOST_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hostNetwork").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::hostNetwork)).setter(EksPodPropertiesDetail.setter(Builder::hostNetwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostNetwork").build()}).build();
    private static final SdkField<String> DNS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsPolicy").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::dnsPolicy)).setter(EksPodPropertiesDetail.setter(Builder::dnsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsPolicy").build()}).build();
    private static final SdkField<List<EksContainerDetail>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::containers)).setter(EksPodPropertiesDetail.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksContainerDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EksVolume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::volumes)).setter(EksPodPropertiesDetail.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("podName").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::podName)).setter(EksPodPropertiesDetail.setter(Builder::podName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podName").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::nodeName)).setter(EksPodPropertiesDetail.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<EksMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(EksPodPropertiesDetail.getter(EksPodPropertiesDetail::metadata)).setter(EksPodPropertiesDetail.setter(Builder::metadata)).constructor(EksMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_NAME_FIELD, HOST_NETWORK_FIELD, DNS_POLICY_FIELD, CONTAINERS_FIELD, VOLUMES_FIELD, POD_NAME_FIELD, NODE_NAME_FIELD, METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceAccountName;
    private final Boolean hostNetwork;
    private final String dnsPolicy;
    private final List<EksContainerDetail> containers;
    private final List<EksVolume> volumes;
    private final String podName;
    private final String nodeName;
    private final EksMetadata metadata;

    private EksPodPropertiesDetail(BuilderImpl builder) {
        this.serviceAccountName = builder.serviceAccountName;
        this.hostNetwork = builder.hostNetwork;
        this.dnsPolicy = builder.dnsPolicy;
        this.containers = builder.containers;
        this.volumes = builder.volumes;
        this.podName = builder.podName;
        this.nodeName = builder.nodeName;
        this.metadata = builder.metadata;
    }

    public final String serviceAccountName() {
        return this.serviceAccountName;
    }

    public final Boolean hostNetwork() {
        return this.hostNetwork;
    }

    public final String dnsPolicy() {
        return this.dnsPolicy;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<EksContainerDetail> containers() {
        return this.containers;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<EksVolume> volumes() {
        return this.volumes;
    }

    public final String podName() {
        return this.podName;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final EksMetadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.podName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPodPropertiesDetail)) {
            return false;
        }
        EksPodPropertiesDetail other = (EksPodPropertiesDetail)obj;
        return Objects.equals(this.serviceAccountName(), other.serviceAccountName()) && Objects.equals(this.hostNetwork(), other.hostNetwork()) && Objects.equals(this.dnsPolicy(), other.dnsPolicy()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.podName(), other.podName()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"EksPodPropertiesDetail").add("ServiceAccountName", (Object)this.serviceAccountName()).add("HostNetwork", (Object)this.hostNetwork()).add("DnsPolicy", (Object)this.dnsPolicy()).add("Containers", this.hasContainers() ? this.containers() : null).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("PodName", (Object)this.podName()).add("NodeName", (Object)this.nodeName()).add("Metadata", (Object)this.metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceAccountName": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountName()));
            }
            case "hostNetwork": {
                return Optional.ofNullable(clazz.cast(this.hostNetwork()));
            }
            case "dnsPolicy": {
                return Optional.ofNullable(clazz.cast(this.dnsPolicy()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "podName": {
                return Optional.ofNullable(clazz.cast(this.podName()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksPodPropertiesDetail, T> g) {
        return obj -> g.apply((EksPodPropertiesDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccountName;
        private Boolean hostNetwork;
        private String dnsPolicy;
        private List<EksContainerDetail> containers = DefaultSdkAutoConstructList.getInstance();
        private List<EksVolume> volumes = DefaultSdkAutoConstructList.getInstance();
        private String podName;
        private String nodeName;
        private EksMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(EksPodPropertiesDetail model) {
            this.serviceAccountName(model.serviceAccountName);
            this.hostNetwork(model.hostNetwork);
            this.dnsPolicy(model.dnsPolicy);
            this.containers(model.containers);
            this.volumes(model.volumes);
            this.podName(model.podName);
            this.nodeName(model.nodeName);
            this.metadata(model.metadata);
        }

        public final String getServiceAccountName() {
            return this.serviceAccountName;
        }

        public final void setServiceAccountName(String serviceAccountName) {
            this.serviceAccountName = serviceAccountName;
        }

        @Override
        public final Builder serviceAccountName(String serviceAccountName) {
            this.serviceAccountName = serviceAccountName;
            return this;
        }

        public final Boolean getHostNetwork() {
            return this.hostNetwork;
        }

        public final void setHostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
        }

        @Override
        public final Builder hostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
            return this;
        }

        public final String getDnsPolicy() {
            return this.dnsPolicy;
        }

        public final void setDnsPolicy(String dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
        }

        @Override
        public final Builder dnsPolicy(String dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
            return this;
        }

        public final List<EksContainerDetail.Builder> getContainers() {
            List<EksContainerDetail.Builder> result = EksContainerDetailsCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<EksContainerDetail.BuilderImpl> containers) {
            this.containers = EksContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<EksContainerDetail> containers) {
            this.containers = EksContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(EksContainerDetail ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<EksContainerDetail.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (EksContainerDetail)((EksContainerDetail.Builder)EksContainerDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EksVolume.Builder> getVolumes() {
            List<EksVolume.Builder> result = EksVolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<EksVolume.BuilderImpl> volumes) {
            this.volumes = EksVolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<EksVolume> volumes) {
            this.volumes = EksVolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(EksVolume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<EksVolume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (EksVolume)((EksVolume.Builder)EksVolume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPodName() {
            return this.podName;
        }

        public final void setPodName(String podName) {
            this.podName = podName;
        }

        @Override
        public final Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final EksMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(EksMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EksMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public EksPodPropertiesDetail build() {
            return new EksPodPropertiesDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksPodPropertiesDetail> {
        public Builder serviceAccountName(String var1);

        public Builder hostNetwork(Boolean var1);

        public Builder dnsPolicy(String var1);

        public Builder containers(Collection<EksContainerDetail> var1);

        public Builder containers(EksContainerDetail ... var1);

        public Builder containers(Consumer<EksContainerDetail.Builder> ... var1);

        public Builder volumes(Collection<EksVolume> var1);

        public Builder volumes(EksVolume ... var1);

        public Builder volumes(Consumer<EksVolume.Builder> ... var1);

        public Builder podName(String var1);

        public Builder nodeName(String var1);

        public Builder metadata(EksMetadata var1);

        default public Builder metadata(Consumer<EksMetadata.Builder> metadata) {
            return this.metadata((EksMetadata)((EksMetadata.Builder)EksMetadata.builder().applyMutation(metadata)).build());
        }
    }
}

