/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketClient;
import software.amazon.awssdk.services.braket.internal.UserAgentUtils;
import software.amazon.awssdk.services.braket.model.DeviceSummary;
import software.amazon.awssdk.services.braket.model.SearchDevicesRequest;
import software.amazon.awssdk.services.braket.model.SearchDevicesResponse;

public class SearchDevicesIterable
implements SdkIterable<SearchDevicesResponse> {
    private final BraketClient client;
    private final SearchDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchDevicesIterable(BraketClient client, SearchDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchDevicesResponseFetcher();
    }

    public Iterator<SearchDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeviceSummary> devices() {
        Function<SearchDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchDevicesResponseFetcher
    implements SyncPageFetcher<SearchDevicesResponse> {
        private SearchDevicesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchDevicesResponse nextPage(SearchDevicesResponse previousPage) {
            if (previousPage == null) {
                return SearchDevicesIterable.this.client.searchDevices(SearchDevicesIterable.this.firstRequest);
            }
            return SearchDevicesIterable.this.client.searchDevices((SearchDevicesRequest)((Object)SearchDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

