/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.ActionSubType;
import software.amazon.awssdk.services.budgets.model.InstanceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SsmActionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SsmActionDefinition> {
    private static final SdkField<String> ACTION_SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionSubType").getter(SsmActionDefinition.getter(SsmActionDefinition::actionSubTypeAsString)).setter(SsmActionDefinition.setter(Builder::actionSubType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionSubType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(SsmActionDefinition.getter(SsmActionDefinition::region)).setter(SsmActionDefinition.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(SsmActionDefinition.getter(SsmActionDefinition::instanceIds)).setter(SsmActionDefinition.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_SUB_TYPE_FIELD, REGION_FIELD, INSTANCE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionSubType;
    private final String region;
    private final List<String> instanceIds;

    private SsmActionDefinition(BuilderImpl builder) {
        this.actionSubType = builder.actionSubType;
        this.region = builder.region;
        this.instanceIds = builder.instanceIds;
    }

    public final ActionSubType actionSubType() {
        return ActionSubType.fromValue(this.actionSubType);
    }

    public final String actionSubTypeAsString() {
        return this.actionSubType;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionSubTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmActionDefinition)) {
            return false;
        }
        SsmActionDefinition other = (SsmActionDefinition)obj;
        return Objects.equals(this.actionSubTypeAsString(), other.actionSubTypeAsString()) && Objects.equals(this.region(), other.region()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds());
    }

    public final String toString() {
        return ToString.builder((String)"SsmActionDefinition").add("ActionSubType", (Object)this.actionSubTypeAsString()).add("Region", (Object)this.region()).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionSubType": {
                return Optional.ofNullable(clazz.cast(this.actionSubTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SsmActionDefinition, T> g) {
        return obj -> g.apply((SsmActionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionSubType;
        private String region;
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SsmActionDefinition model) {
            this.actionSubType(model.actionSubType);
            this.region(model.region);
            this.instanceIds(model.instanceIds);
        }

        public final String getActionSubType() {
            return this.actionSubType;
        }

        public final void setActionSubType(String actionSubType) {
            this.actionSubType = actionSubType;
        }

        @Override
        public final Builder actionSubType(String actionSubType) {
            this.actionSubType = actionSubType;
            return this;
        }

        @Override
        public final Builder actionSubType(ActionSubType actionSubType) {
            this.actionSubType(actionSubType == null ? null : actionSubType.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public SsmActionDefinition build() {
            return new SsmActionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SsmActionDefinition> {
        public Builder actionSubType(String var1);

        public Builder actionSubType(ActionSubType var1);

        public Builder region(String var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);
    }
}

