/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse;
import software.amazon.awssdk.services.budgets.model.Subscriber;

public class DescribeSubscribersForNotificationPublisher
implements SdkPublisher<DescribeSubscribersForNotificationResponse> {
    private final BudgetsAsyncClient client;
    private final DescribeSubscribersForNotificationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSubscribersForNotificationPublisher(BudgetsAsyncClient client, DescribeSubscribersForNotificationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSubscribersForNotificationPublisher(BudgetsAsyncClient client, DescribeSubscribersForNotificationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSubscribersForNotificationResponseFetcher();
    }

    public void subscribe(org.reactivestreams.Subscriber<? super DescribeSubscribersForNotificationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Subscriber> subscribers() {
        Function<DescribeSubscribersForNotificationResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscribers() != null) {
                return response.subscribers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSubscribersForNotificationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSubscribersForNotificationResponseFetcher
    implements AsyncPageFetcher<DescribeSubscribersForNotificationResponse> {
        private DescribeSubscribersForNotificationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubscribersForNotificationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSubscribersForNotificationResponse> nextPage(DescribeSubscribersForNotificationResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubscribersForNotificationPublisher.this.client.describeSubscribersForNotification(DescribeSubscribersForNotificationPublisher.this.firstRequest);
            }
            return DescribeSubscribersForNotificationPublisher.this.client.describeSubscribersForNotification((DescribeSubscribersForNotificationRequest)((Object)DescribeSubscribersForNotificationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

