/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteChannelModeratorRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, DeleteChannelModeratorRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(DeleteChannelModeratorRequest.getter(DeleteChannelModeratorRequest::channelArn)).setter(DeleteChannelModeratorRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> CHANNEL_MODERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelModeratorArn").getter(DeleteChannelModeratorRequest.getter(DeleteChannelModeratorRequest::channelModeratorArn)).setter(DeleteChannelModeratorRequest.setter(Builder::channelModeratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelModeratorArn").build()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(DeleteChannelModeratorRequest.getter(DeleteChannelModeratorRequest::chimeBearer)).setter(DeleteChannelModeratorRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CHANNEL_MODERATOR_ARN_FIELD, CHIME_BEARER_FIELD));
    private final String channelArn;
    private final String channelModeratorArn;
    private final String chimeBearer;

    private DeleteChannelModeratorRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.channelModeratorArn = builder.channelModeratorArn;
        this.chimeBearer = builder.chimeBearer;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String channelModeratorArn() {
        return this.channelModeratorArn;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelModeratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChannelModeratorRequest)) {
            return false;
        }
        DeleteChannelModeratorRequest other = (DeleteChannelModeratorRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.channelModeratorArn(), other.channelModeratorArn()) && Objects.equals(this.chimeBearer(), other.chimeBearer());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteChannelModeratorRequest").add("ChannelArn", (Object)this.channelArn()).add("ChannelModeratorArn", (Object)this.channelModeratorArn()).add("ChimeBearer", (Object)this.chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "ChannelModeratorArn": {
                return Optional.ofNullable(clazz.cast(this.channelModeratorArn()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteChannelModeratorRequest, T> g) {
        return obj -> g.apply((DeleteChannelModeratorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String channelModeratorArn;
        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChannelModeratorRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.channelModeratorArn(model.channelModeratorArn);
            this.chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getChannelModeratorArn() {
            return this.channelModeratorArn;
        }

        public final void setChannelModeratorArn(String channelModeratorArn) {
            this.channelModeratorArn = channelModeratorArn;
        }

        @Override
        public final Builder channelModeratorArn(String channelModeratorArn) {
            this.channelModeratorArn = channelModeratorArn;
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteChannelModeratorRequest build() {
            return new DeleteChannelModeratorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteChannelModeratorRequest> {
        public Builder channelArn(String var1);

        public Builder channelModeratorArn(String var1);

        public Builder chimeBearer(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

