/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse;

public class ListPhoneNumberOrdersIterable
implements SdkIterable<ListPhoneNumberOrdersResponse> {
    private final ChimeClient client;
    private final ListPhoneNumberOrdersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPhoneNumberOrdersIterable(ChimeClient client, ListPhoneNumberOrdersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPhoneNumberOrdersResponseFetcher();
    }

    public Iterator<ListPhoneNumberOrdersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPhoneNumberOrdersResponseFetcher
    implements SyncPageFetcher<ListPhoneNumberOrdersResponse> {
        private ListPhoneNumberOrdersResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumberOrdersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPhoneNumberOrdersResponse nextPage(ListPhoneNumberOrdersResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumberOrdersIterable.this.client.listPhoneNumberOrders(ListPhoneNumberOrdersIterable.this.firstRequest);
            }
            return ListPhoneNumberOrdersIterable.this.client.listPhoneNumberOrders((ListPhoneNumberOrdersRequest)((Object)ListPhoneNumberOrdersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

