/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LiveConnectorRTMPConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiveConnectorRTMPConfiguration> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(LiveConnectorRTMPConfiguration.getter(LiveConnectorRTMPConfiguration::url)).setter(LiveConnectorRTMPConfiguration.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> AUDIO_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioChannels").getter(LiveConnectorRTMPConfiguration.getter(LiveConnectorRTMPConfiguration::audioChannelsAsString)).setter(LiveConnectorRTMPConfiguration.setter(Builder::audioChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioChannels").build()}).build();
    private static final SdkField<String> AUDIO_SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioSampleRate").getter(LiveConnectorRTMPConfiguration.getter(LiveConnectorRTMPConfiguration::audioSampleRate)).setter(LiveConnectorRTMPConfiguration.setter(Builder::audioSampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioSampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, AUDIO_CHANNELS_FIELD, AUDIO_SAMPLE_RATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String audioChannels;
    private final String audioSampleRate;

    private LiveConnectorRTMPConfiguration(BuilderImpl builder) {
        this.url = builder.url;
        this.audioChannels = builder.audioChannels;
        this.audioSampleRate = builder.audioSampleRate;
    }

    public final String url() {
        return this.url;
    }

    public final AudioChannelsOption audioChannels() {
        return AudioChannelsOption.fromValue(this.audioChannels);
    }

    public final String audioChannelsAsString() {
        return this.audioChannels;
    }

    public final String audioSampleRate() {
        return this.audioSampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioChannelsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSampleRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveConnectorRTMPConfiguration)) {
            return false;
        }
        LiveConnectorRTMPConfiguration other = (LiveConnectorRTMPConfiguration)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.audioChannelsAsString(), other.audioChannelsAsString()) && Objects.equals(this.audioSampleRate(), other.audioSampleRate());
    }

    public final String toString() {
        return ToString.builder((String)"LiveConnectorRTMPConfiguration").add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("AudioChannels", (Object)this.audioChannelsAsString()).add("AudioSampleRate", (Object)this.audioSampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "AudioChannels": {
                return Optional.ofNullable(clazz.cast(this.audioChannelsAsString()));
            }
            case "AudioSampleRate": {
                return Optional.ofNullable(clazz.cast(this.audioSampleRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LiveConnectorRTMPConfiguration, T> g) {
        return obj -> g.apply((LiveConnectorRTMPConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String audioChannels;
        private String audioSampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveConnectorRTMPConfiguration model) {
            this.url(model.url);
            this.audioChannels(model.audioChannels);
            this.audioSampleRate(model.audioSampleRate);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getAudioChannels() {
            return this.audioChannels;
        }

        public final void setAudioChannels(String audioChannels) {
            this.audioChannels = audioChannels;
        }

        @Override
        public final Builder audioChannels(String audioChannels) {
            this.audioChannels = audioChannels;
            return this;
        }

        @Override
        public final Builder audioChannels(AudioChannelsOption audioChannels) {
            this.audioChannels(audioChannels == null ? null : audioChannels.toString());
            return this;
        }

        public final String getAudioSampleRate() {
            return this.audioSampleRate;
        }

        public final void setAudioSampleRate(String audioSampleRate) {
            this.audioSampleRate = audioSampleRate;
        }

        @Override
        public final Builder audioSampleRate(String audioSampleRate) {
            this.audioSampleRate = audioSampleRate;
            return this;
        }

        public LiveConnectorRTMPConfiguration build() {
            return new LiveConnectorRTMPConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiveConnectorRTMPConfiguration> {
        public Builder url(String var1);

        public Builder audioChannels(String var1);

        public Builder audioChannels(AudioChannelsOption var1);

        public Builder audioSampleRate(String var1);
    }
}

